/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.ContextMenuSample
{
    [Export(typeof(IMenu<DocumentFilesContext>))]
    public class DocumentFilesContextMenuPlugin : IMenu<DocumentFilesContext>
    {
        private const string SHOW_INFO_ITEM_NAME = "miShowInfo";

        public void Build(IMenuBuilder builder, DocumentFilesContext context)
        {
            builder.AddItem(SHOW_INFO_ITEM_NAME, builder.Count).WithHeader("Показать информацию");
        }

        public void OnMenuItemClick(string name, DocumentFilesContext context)
        {
            if (name == SHOW_INFO_ITEM_NAME)
            {
                var info = context.IsMounted
                    ? $"Документ {context.EcmDocument.DisplayName} смонтирован в рабочую папку"
                    : $"Документ {context.EcmDocument.DisplayName} не смонтирован в рабочую папку";
                info += Environment.NewLine + $"Выбрано элементов: {context.SelectedObjects.Count()}";
                foreach (var obj in context.SelectedObjects)
                {
                    info += Environment.NewLine + obj.Path;
                }
                MessageBox.Show(info, "Информация");
            }
        }
    }
}
