/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.ContextMenuSample
{
    [Export(typeof(IMenu<LinkedTasksContext2>))]
    public class LinkedTasksContextMenuPlugin : IMenu<LinkedTasksContext2>
    {
        private const string MENU_ITEM_NAME = "miShowInfo";

        public void Build(IMenuBuilder builder, LinkedTasksContext2 context)
        {
            builder.AddItem(MENU_ITEM_NAME, builder.Count).WithHeader("Показать информацию");
        }

        public void OnMenuItemClick(string name, LinkedTasksContext2 context)
        {
            if (name == MENU_ITEM_NAME)
            {
                MessageBox.Show($"Выбрано заданий: {context.SelectedTasks.Count()}");
            }
        }
    }
}
