/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.ContextMenuSample
{
    [Export(typeof(IMenu<TasksViewContext2>))]
    public class TaskContextMenuPlugin : IMenu<TasksViewContext2>
    {
        public void Build(IMenuBuilder builder, TasksViewContext2 context)
        {
            var tasks = context.SelectedTasks.ToList();
            if (tasks.Count == 1)
            {
                builder.AddItem("PluginTaskMenuItem", 0).WithHeader("Menu for task");
                builder.AddSeparator(1);
                return;
            }

            if (tasks.Count > 1)
            {
                builder.AddItem("PluginTaskMenuItem", 0).WithHeader("Menu for selected tasks");
                builder.AddSeparator(1);
                return;
            }

            if (tasks.Count == 0)
            {
                builder.AddItem("PluginTaskMenuItem", 0).WithHeader("Menu for empty area");
                builder.AddSeparator(1);
            }
        }

        public void OnMenuItemClick(string name, TasksViewContext2 context)
        {
            if (name == "PluginTaskMenuItem")
                MessageBox.Show("PluginTaskMenuItem was clicked");
        }
    }
}
