/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;

namespace Ascon.Pilot.SDK.EventSample
{
    [Export(typeof(INewTabPage))]
    [ExportMetadata("Name", "Event plugin sample")]
    public class EventSamplePlugin : INewTabPage
    {
        private readonly ITabServiceProvider _tabServiceProvider;
        private readonly EventSubscriber _subscriber;

        [ImportingConstructor]
        public EventSamplePlugin(IEventAggregator eventAggregator, ITabServiceProvider tabServiceProvider)
        {
            _tabServiceProvider = tabServiceProvider;
            _subscriber = new EventSubscriber(eventAggregator);
            _subscriber.Subscribe();
        }

        public void BuildNewTabPage(INewTabPageHost host)
        {
            host.AddButton(Constants.PluginName, "OpenExtensionButtonCommand", "Open tab with event plugin sample", null);
        }

        public void OnButtonClick(string name)
        {
            if (name != "OpenExtensionButtonCommand") 
                return;
            
            var title = _tabServiceProvider.GetActiveTabPageTitle();
            _tabServiceProvider.UpdateTabPageContent(title, Constants.PluginName, new MainView());
        }
    }
}