/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/

using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.FileSnapshotSample
{
    class ReasonViewModel : PropertyChangedBase
    {
        private string _reason = string.Empty;
        
        public ReasonViewModel(string title)
        {
            ObjectTitle = $"Specify the replacement reason for \"{title}\"";
        }

        public string ObjectTitle { get; private set; }

        public string Reason
        {
            get => _reason;
            set
            {
                _reason = value;
                NotifyOfPropertyChange(nameof(Reason));
            }
        }
    }
}
