/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Interop;
using System.Windows.Media;
using Ascon.Pilot.Theme.ColorScheme;

namespace Ascon.Pilot.SDK.FileSnapshotSample
{
    [Export(typeof(IStorageContextMenu))]
    public class StorageFileSnapshotSample : IStorageContextMenu
    {
        private readonly IObjectsRepository _repository;
        private readonly IObjectModifier _modifier;
        private Guid _selectedId;

        [ImportingConstructor]
        public StorageFileSnapshotSample(IPilotDialogService dialogService, IObjectsRepository repository, IObjectModifier modifier)
        {
            _repository = repository;
            _modifier = modifier;
            var convertFromString = ColorConverter.ConvertFromString(dialogService.AccentColor);
            if (convertFromString != null)
            {
                var accentColor = (Color)convertFromString;
                ColorScheme.Initialize(accentColor);
            }
        }

        public void BuildContextMenu(IMenuHost menuHost, IEnumerable<IStorageDataObject> selection)
        {
            var objects = selection.ToList();
            if (objects.Count != 1)
                return;

            var current = objects.Single();
            if (!current.IsDirectory)
            {
                menuHost.AddItem("MenuCommand", "Show file versions", null, 0);
                _selectedId = current.DataObject.Id;
            }
        }

        [DllImport("user32.dll")]
        static extern IntPtr GetForegroundWindow();

        public void OnMenuItemClick(string itemName)
        {
            var thread = new Thread(() =>
            {
                IntPtr activeWindowHandle = GetForegroundWindow();
                var view = new DocumentHistoryView();
                var model = new FileHistoryViewModel(_selectedId, _repository, _modifier, view.Dispatcher);
                view.DataContext = model;
                view.ShowInTaskbar = true;
                var wih = new WindowInteropHelper(view);
                wih.Owner = activeWindowHandle;
                view.ShowDialog();
            });

            thread.SetApartmentState(ApartmentState.STA);
            thread.Start();
        }
    }
}
