/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK.Data;

namespace Ascon.Pilot.SDK.HistorySample
{
    class HistoryItemModel : INotifyPropertyChanged
    {
        public HistoryItemModel(IHistoryItem historyItem)
        {
            DateTime = historyItem.Created.ToLocalTime();
            Reason = historyItem.Reason;
        }

        public DateTime DateTime { get; set; }

        public string Reason { get; set; }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
