/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Interop;
using Ascon.Pilot.SDK.Data;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.HistorySample
{
    [Export(typeof(IMenu<TasksViewContext2>))]
    public class TaskHistorySample : IMenu<TasksViewContext2>, IObserver<IHistoryItem>
    {
        private readonly IObjectsRepository _repository;
        protected internal const string History = "HISTORY";
        private IDisposable _subscription;
        private ConcurrentBag<IHistoryItem> _items;

        [DllImport("user32.dll")]
        public static extern IntPtr GetForegroundWindow();

        [ImportingConstructor]
        public TaskHistorySample(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public void Build(IMenuBuilder builder, TasksViewContext2 context)
        {
            var position = builder.ItemNames.Count();
            builder.AddItem(History, position).WithHeader("History");
        }

        public void OnMenuItemClick(string name, TasksViewContext2 context)
        {
            if (name == History)
            {
                var selected = context.SelectedTasks.FirstOrDefault();
                if (selected == null)
                    return;
                _items = new ConcurrentBag<IHistoryItem>();
                _subscription = _repository.GetHistoryItems(selected.HistoryItems()).Subscribe(this);

            }
        }

        public void OnNext(IHistoryItem value)
        {
            _items.Add(value);
        }

        public void OnError(Exception error)
        {

        }

        public void OnCompleted()
        {
            _subscription.Dispose();
            var model = new List<HistoryItemModel>();

            foreach (var historyItem in _items)
            {
                model.Add(new HistoryItemModel(historyItem));
            }

            var view = new HistoryList { DataContext = model };
            var activeWindowHandle = GetForegroundWindow();
            new WindowInteropHelper(view)
            {
                Owner = activeWindowHandle
            };
            view.ShowDialog();
            System.Windows.Threading.Dispatcher.Run();
        }
    }
}
