/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Linq;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.SDK.Controls;

namespace Ascon.Pilot.SDK.ModifyObjectsSample
{
    [Export(typeof(IMenu<ObjectsViewContext>))]
    public class ModifyObjectsPlugin : IMenu<ObjectsViewContext>
    {
        private readonly IObjectModifier _modifier;
        private readonly IObjectsRepository _repository;
        private const string CREATE_COPY_ITEM_NAME = "CreateCopyItemName";
        private IDataObject _selected;

        [ImportingConstructor]
        public ModifyObjectsPlugin(IObjectModifier modifier, IObjectsRepository repository)
        {
            _modifier = modifier;
            _repository = repository;
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            if (context.IsContext)
                return;

            var dataObjects = context.SelectedObjects.ToArray();
            if (dataObjects.Length != 1)
                return;

            var itemNames = builder.ItemNames.ToList();
            const string indexItemName = "miCut";
            var insertIndex = itemNames.IndexOf(indexItemName) + 1;

            _selected = dataObjects.FirstOrDefault();
            builder.AddItem(CREATE_COPY_ITEM_NAME, insertIndex).WithHeader("Co_py");
        }

        public async void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            if (name != CREATE_COPY_ITEM_NAME) return;

            var loader = new ObjectLoader(_repository);
            var parent = await loader.Load(_selected.ParentId);
            var builder = _modifier.Create(parent, _selected.Type);
            foreach (var attribute in _selected.Attributes)
            {
                if (attribute.Value is string strValue)
                    builder.SetAttribute(attribute.Key, strValue);
                if (attribute.Value is int intValue)
                    builder.SetAttribute(attribute.Key, intValue);
                if (attribute.Value is double doubleValue)
                    builder.SetAttribute(attribute.Key, doubleValue);
                if (attribute.Value is DateTime timeValue)
                    builder.SetAttribute(attribute.Key, timeValue);
                if (attribute.Value is string[] arrayValue)
                    builder.SetAttribute(attribute.Key, arrayValue);
            }
            _modifier.Apply();
        }
    }
}
