/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel;
using Ascon.Pilot.SDK.ObjectCard;
using Ascon.Pilot.SDK.ObjectCardControlSample.Annotations;

namespace Ascon.Pilot.SDK.ObjectCardControlSample
{
    class ExtensionObjectCardDialogViewModel : INotifyPropertyChanged
    {
        private readonly IObjectsRepository _repository;
        private readonly IObjectCardControlProvider _cardControlProvider;
        private ObjectCardControl _objectCardControl;
        public event PropertyChangedEventHandler PropertyChanged;

        public ObjectCardControl ObjectCardControl
        {
            get => _objectCardControl;
            set
            {
                _objectCardControl = value;
                OnPropertyChanged(nameof(ObjectCardControl));
            }
        }

        public ExtensionObjectCardDialogViewModel(
            IObjectsRepository repository,
            IObjectCardControlProvider cardControlProvider,
            Guid editedObjectId)
        {
            _repository = repository;
            _cardControlProvider = cardControlProvider;

            ObjectCardControl = cardControlProvider.GetObjectCardControl(
                objectId: editedObjectId, 
                isReadonly: true);

            ObjectCardControl.Interaction.UseCompactScrollbar();
        }

        [NotifyPropertyChangedInvocator]
        protected virtual void OnPropertyChanged(string propertyName)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}