/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;

namespace Ascon.Pilot.SDK.ContextMenuSample
{
    class IconLoader
    {
        public static byte[] GetIcon(string resourceName)
        {
            using (var stream = typeof(IconLoader).Assembly.GetManifestResourceStream($"Ascon.Pilot.SDK.OpenDocumentInNewTabSample.Resources.{resourceName}"))
            {
                return ReadBytes(stream);
            }
        }

        private static byte[] ReadBytes(Stream input)
        {
            using (var ms = new MemoryStream())
            {
                input.CopyTo(ms);
                return ms.ToArray();
            }
        }
    }
}
