﻿using Ascon.Pilot.SDK.Menu;
using System.ComponentModel.Composition;
using System.Linq;
using System.Reactive.Linq;
using System.Threading;
using System.Threading.Tasks;
using Ascon.Pilot.SDK.Extensions;

namespace Ascon.Pilot.SDK.SearchSample.SmartFolderSearch
{
    [Export(typeof(IMenu<ObjectsViewContext>))]
    public class SmartFolderContextMenu : IMenu<ObjectsViewContext>
    {
        private readonly ISearchService _searchService;
        private readonly IObjectsRepository _repository;
        
        private const string SearchItemName = "mniSearchInSmartFolder";

        [ImportingConstructor]
        public SmartFolderContextMenu(ISearchService searchService, IObjectsRepository repository)
        {
            _searchService = searchService;
            _repository = repository;
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            if(context.SelectedObjects.Count() != 1)
                return;

            var selectedObject = context.SelectedObjects.First();
            if(selectedObject.Type.Name != SystemTypeNames.SMART_FOLDER)
                return;

            builder.AddItem(SearchItemName, builder.Count).WithHeader("Поиск в умной папке");
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            if (name != SearchItemName)
                return;

            var smartFolder = context.SelectedObjects.First();
            var searchExpression = (string)smartFolder.Attributes[SystemAttributeNames.SEARCH_CRITERIA];
            _ = SearchInSmartFolder(searchExpression);
        }

        private async Task SearchInSmartFolder(string searchExpression)
        {
            var queryBuilder = _searchService.GetQueryBuilderFromDocumentExplorerSearchExpression(searchExpression, true);
            var result = await _searchService.Search(queryBuilder).FirstAsync(x => x.Kind == SearchResultKind.Remote);
            var found = await _repository.GetObjectsAsync(result.Result, CancellationToken.None);
            var window = new SmartFolderResultsWindow
            {
                DataContext = found
            };
            window.ShowDialog();
        }
    }
}
