/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using Ascon.Pilot.SDK.Menu;

namespace Ascon.Pilot.SDK.SystemTrayMenuSample
{
    [Export(typeof(IMenu<SystemTrayContext>))]
    public class SystemTrayMenuPlugin : IMenu<SystemTrayContext>
    {
        private const string MY_MENU = "ServiceMyMenu";
        
        public void Build(IMenuBuilder builder, SystemTrayContext context)
        {
            builder.AddItem(MY_MENU, 1).WithHeader("My menu");
        }

        public void OnMenuItemClick(string name, SystemTrayContext context)
        {
            if (name == MY_MENU)
            {
                new MessageBox().ShowDialog();
            }
        }
    }
}
