/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using Ascon.Pilot.SDK.Toolbar;

namespace Ascon.Pilot.SDK.ToolbarSample
{
    [Export(typeof(IToolbar<LinkedTasksContext2>))]
    public class LinkedTasksToolbarSample : IToolbar<LinkedTasksContext2>
    {
        private const string MENU_ITEM_NAME = "miShowInfo";

        public void Build(IToolbarBuilder builder, LinkedTasksContext2 context)
        {
            builder.AddButtonItem(MENU_ITEM_NAME, builder.Count).WithHeader("Показать информацию");
        }

        public void OnToolbarItemClick(string name, LinkedTasksContext2 context)
        {
            if (name == MENU_ITEM_NAME)
            {
                MessageBox.Show($"Выбрано заданий: {context.SelectedTasks.Count()}");
            }
        }
    }
}
