/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.SDK.Toolbar;

namespace Ascon.Pilot.SDK.ToolbarSample
{
    [Export(typeof(IToolbar<XpsMergerContext>))]
    public class XpsMergerToolbarSample : ToolbarItemSubmenuHandler, IToolbar<XpsMergerContext>
    {
        private readonly IXpsMerger _xpsMerger;

        [ImportingConstructor]
        public XpsMergerToolbarSample(IXpsMerger xpsMerger)
        {
            _xpsMerger = xpsMerger;
        }

        public override void OnSubmenuRequested(IToolbarBuilder builder)
        {
            builder.AddButtonItem(ToolbarItemNames.SAVE_MERGED_DOCUMENT, builder.Count).WithHeader("Save as...");
        }

        public void Build(IToolbarBuilder builder, XpsMergerContext context)
        {
            var saveMenu = builder.ReplaceMenuButtonItem("tbiSave");
            saveMenu.WithMenu(this);
        }

        public void OnToolbarItemClick(string name, XpsMergerContext context)
        {
            if (name == ToolbarItemNames.SAVE_MERGED_DOCUMENT)
            {
                if (_xpsMerger != null)
                {
                    var filePath = Path.GetTempFileName() + ".xps";
                    _xpsMerger.SaveMergedXps(filePath, new MergerSaveListener());
                }
            }
        }
    }
}
