/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;

namespace Ascon.Pilot.SDK.WPFSample.Pages
{
    /// <summary>
    ///     Interaction logic for LayoutAndMenus.xaml
    /// </summary>
    public partial class LayoutAndMenus : UserControl
    {
        public LayoutAndMenus()
        {
            InitializeComponent();

            Loaded += LayoutAndMenusLoaded;
        }

        public List<string> LeftItems { get; set; }
        public List<string> RightItems { get; set; }

        private void LayoutAndMenusLoaded(object sender, RoutedEventArgs e)
        {
            LeftItems = PopulateItems();
            RightItems = PopulateItems();
            DataContext = this;
        }

        private List<string> PopulateItems()
        {
            var items = new List<string>();
            for (var i = 0; i < 100; i++)
                items.Add("Item #" + i);
            return items;
        }

        private void ShowVerticalScrollbarMenuItemOnClick(object sender, RoutedEventArgs e)
        {
            var item = (MenuItem) sender;
            LeftScrollViewer.VerticalScrollBarVisibility = item.IsChecked
                ? ScrollBarVisibility.Visible
                : ScrollBarVisibility.Hidden;
        }

        private void ShowHorizontalScrollbarMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var item = (MenuItem) sender;
            LeftScrollViewer.HorizontalScrollBarVisibility = item.IsChecked
                ? ScrollBarVisibility.Visible
                : ScrollBarVisibility.Hidden;
        }

        private void ShowContextMenu(object sender, RoutedEventArgs e)
        {
            LeftScrollViewer.ContextMenu.PlacementTarget = LeftScrollViewer;
            LeftScrollViewer.ContextMenu.Placement = PlacementMode.Center;
            LeftScrollViewer.ContextMenu.IsOpen = true;
        }

        private void ShowCompactScrollbar(object sender, RoutedEventArgs e)
        {
            RightScrollViewer.Visibility = Visibility.Visible;
        }
    }
}