﻿using Ascon.Pilot.SDK;
using ProjectCloneWizard;
using System.Windows.Input;
using Ascon.Pilot.SDK.Controls.Commands;

namespace BatchDigitalSigner
{
    public enum ExceptionDialogResult
    {
        TryAgain,
        Skip
    }
    public class DialogButtonTitleInfo
    {
        public string Title { get; set; }
        public string Subtitle { get; set; }
    }
    public class ExceptionDialogModel
    {
        private IDataObject _element;
        private ExceptionDialog _exceptionDialog;
        private System.Windows.Window _owner;

        public ExceptionDialogResult? CloseResult { get; private set; }
        public ExceptionDialogModel(IDataObject element, string errorMessage, System.Windows.Window owner)
        {
            _element = element;
            _owner = owner;
            ErrorMessage = errorMessage;
            TryAgainCommand = new DelegateCommand(() =>
            {
                CloseResult = ExceptionDialogResult.TryAgain;
                _exceptionDialog.Close();
            });

            SkipCommand = new DelegateCommand(() =>
            {
                CloseResult = ExceptionDialogResult.Skip;
                _exceptionDialog.Close();
            });

            CancelCommand = new DelegateCommand(() => _exceptionDialog.Close());
        }

        public ICommand TryAgainCommand { get; private set; } 
        public ICommand SkipCommand { get; private set; } 
        public ICommand CancelCommand { get; private set; } 

        public string ElementTitle { get; private set; }

        public string ErrorMessage { get; }


        public void Show()
        {
            ElementTitle = _element.GetTitle();
            _exceptionDialog = new ExceptionDialog { DataContext = this };
            _exceptionDialog.Owner = _owner;
            _exceptionDialog.ShowDialog();
        }
    
    }

}
