/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.Theme.Tools;

namespace ChangeFilesMonitor.Converters
{
    public class FilePathToFileNameConverter : BaseValueConverter
    {
        protected override object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var filePath = (string) value;
            if (string.IsNullOrEmpty(filePath))
                return null;
            return Path.GetFileName(filePath);
        }
    }
}
