/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel.Composition;
using System.Windows;
using Ascon.Pilot.SDK;

namespace ChangeFilesMonitor
{
    [Export(typeof(IPilotStorageListener))]
    public class EditedFilesListener : IPilotStorageListener
    {
        private readonly HashSet<Guid> _editedIds = new HashSet<Guid>();

        public EditedFilesListener()
        {
            Current = this;
            Application.Current.Dispatcher.Invoke(() =>
            {
                EditedFiles = new ObservableCollection<string>();
            });
        }

        public static EditedFilesListener Current { get; private set; }
        public ObservableCollection<string> EditedFiles { get; private set; }

        public void FileAdded(Guid id, string path, StorageObjectState state, NotificationTrigger trigger)
        {
            if (state == StorageObjectState.Edited)
                AddEditedFile(id, path);
        }

        public void FileRemoved(Guid id, string path, NotificationTrigger trigger)
        {
            RemoveEditedFile(id, path);
        }

        public void FileStateChanged(Guid id, string path, StorageObjectState newState, NotificationTrigger trigger)
        {
            if (newState == StorageObjectState.Edited)
                AddEditedFile(id, path);
            else
                RemoveEditedFile(id, path);
        }

        public void DirectoryAdded(Guid id, string path, StorageObjectState state, NotificationTrigger trigger)
        {
        }

        public void DirectoryRemoved(Guid id, string path, NotificationTrigger trigger)
        {
        }

        public void FileEdited(Guid id, string path, StorageObjectState state, NotificationTrigger trigger)
        {
        }

        public void DirectoryStateChanged(Guid id, string path, StorageObjectState newState, NotificationTrigger trigger)
        {
        }

        private void AddEditedFile(Guid id, string path)
        {
            if(_editedIds.Add(id))
                EditedFiles.Add(path);
        }

        private void RemoveEditedFile(Guid id, string path)
        {
            if(_editedIds.Remove(id))
                EditedFiles.Remove(path);
        }
    }
}
