/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.ComponentModel;

namespace ChangeFilesMonitor
{
    class FileItem : INotifyPropertyChanged
    {
        public FileItem(Guid id, string path, string name = null)
        {
            Id = id;
            Path = path;
            Name = name ?? (path != null ? System.IO.Path.GetFileName(Path) : null);
        }

        public Guid Id { get; private set; }
        public string Path { get; private set; }

        public string RelativPath => Path.Substring(3);

        public string Name { get; private set; }

        public override bool Equals(object obj)
        {
            var other = obj as FileItem;
            return other != null && other.Id == Id;
        }

        public override int GetHashCode()
        {
            return Id.GetHashCode();
        }

        #region Property Changed
        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void OnPropertyChanged(string propertyName)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        #endregion
    }
}
