/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;

namespace ChangeFilesMonitor.Tools
{
    static class ContextMenuBehavior
    {
        public static readonly DependencyProperty MainViewModelProperty = DependencyProperty.RegisterAttached(
            "MainViewModel", typeof(MainViewModel), typeof(ContextMenuBehavior), new PropertyMetadata(default(MainViewModel), OnMainViewModelChanged));

        private static void OnMainViewModelChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var element = (FrameworkElement) d;
            element.ContextMenuOpening += OnContextMenuOpening;
            element.ContextMenu = new ContextMenu();
        }

        private static void OnContextMenuOpening(object sender, ContextMenuEventArgs e)
        {
            var element = (FrameworkElement) sender;
            var viewModel = GetMainViewModel(element);
            if(viewModel == null)
                return;

            var menu = new ContextMenu();
            viewModel.BuildContextMenu(menu);
            element.ContextMenu = menu;
        }

        public static void SetMainViewModel(DependencyObject element, MainViewModel value)
        {
            element.SetValue(MainViewModelProperty, value);
        }

        public static MainViewModel GetMainViewModel(DependencyObject element)
        {
            return (MainViewModel) element.GetValue(MainViewModelProperty);
        }
    }
}
