/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows;
using System.Windows.Media;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Menu;
using Ascon.Pilot.Theme.ColorScheme;
using Ascon.Pilot.Theme.Controls;
using Ascon.Pilot.Theme.Tools;

namespace ChatsControlProviderSample
{
    [Export(typeof(IMenu<ObjectsViewContext>))]
    public class Main : IMenu<ObjectsViewContext>
    {
        private readonly IChatControlsProvider _chatsControlsProvider;

        [ImportingConstructor]
        public Main(IChatControlsProvider chatsControlsProvider, IPilotDialogService dialogService)
        {
            _chatsControlsProvider = chatsControlsProvider;
            var accentColor = (Color)ColorConverter.ConvertFromString(dialogService.AccentColor);
            ColorScheme.Initialize(accentColor, dialogService.Theme);
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            builder.AddItem("ShowChatsCommand", 0).WithHeader("Show chats");
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            if (name != "ShowChatsCommand")
                return;

            var selectedObject = context.SelectedObjects.FirstOrDefault();
            if (selectedObject == null)
                return;

            var chatControlOptions = _chatsControlsProvider.NewChatControlOptions()
                .WithShowChatInfo(true)
                .WithShowObjectCaption(true);
            var chatControl = _chatsControlsProvider.GetObjectChatsControl(selectedObject.Id, chatControlOptions);

            var controlsView = new Controls
            {
                ChatContentPresenter = { Content = chatControl.View }
            };

            var dialog = new PureWindow
            {
                Content = controlsView,
                Width = 800,
                Height = 600,
                Owner = LayoutHelper.GetOwnerWindow(),
                WindowStartupLocation = WindowStartupLocation.CenterScreen
            };
            dialog.ShowDialog();

        }
    }
}
