/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using Ascon.Pilot.SDK;

namespace CustomXpsAnnotations
{
    /// <summary>
    /// Interaction logic for CustomXpsAnnotation.xaml
    /// </summary>
    public partial class CustomXpsAnnotation : XpsAnnotationSticker
    {
        public CustomXpsAnnotation(Size pageSize) : base(pageSize)
        {
            InitializeComponent();
        }

        private CustomXpsAnnotationViewModel ViewModel => DataContext as CustomXpsAnnotationViewModel;

        public void Select(bool showSticker, bool goToEditMode)
        {
            ChangeSelected(true, showSticker, goToEditMode);

        }

        public void Unselect()
        {
            ChangeSelected(false, false, false);
        }

        protected override UIElement GetElementToTransform()
        {
            return annotationThumb;
        }

        protected override ScaleTransform GetScaleTransform()
        {
            return scaleTransform;
        }

        private void ChangeSelected(bool isSelected, bool showSticker, bool goToEditMode)
        {
            ViewModel.IsSelected = isSelected;
            
            if(showSticker || goToEditMode)
                ViewModel.ShowPopup();
        }

        private void Popup_OnLostKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            var popup = sender as UIElement;

            if (ViewModel.IsPopupOpen 
                && popup != null
                && !popup.IsKeyboardFocusWithin)
            {
                var contextMenu = Keyboard.FocusedElement as ContextMenu;
                if (contextMenu == null)
                {
                    ViewModel.IsPopupOpen = false;
                }
            }
        }

        private void AnnotationThumb_OnPreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            ViewModel.ShowPopup();
        }
    }
}
