/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows;
using System.Windows.Controls.Primitives;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.ObjectCard;
using Ascon.Pilot.Theme.Tools;

namespace CustomXpsAnnotations
{
    class CustomXpsAnnotationAdorner : XpsAnnotationAdorner
    {
        public CustomXpsAnnotationAdorner(DocumentPageView adornedElement, XpsAnnotation annotation,
            IRemarkModifier modifier, IObjectsRepository repository, IObjectCardControlProvider objectCardControlProvider) 
            : base(adornedElement, annotation)
        {
            var pageSize = GetPageSize();
            var annotationVm = new CustomXpsAnnotationViewModel(Annotation, modifier, repository, objectCardControlProvider);
            var annotationControl = new CustomXpsAnnotation(pageSize)
            {
                DataContext = annotationVm
            };

            // Установим свой контрол для отображения на документе
            SetAnnotationControl(annotationControl);
        }

        public override void Select(bool openSticker, bool goToEditMode)
        {
            ((CustomXpsAnnotation)_annotationControl).Select(openSticker, goToEditMode);
        }

        public override void Unselect()
        {
            ((CustomXpsAnnotation)_annotationControl).Unselect();
        }

        public override Rect? ScrollTargetRect
        {
            get
            {
                var thumb = LayoutHelper.FindChildElementByType<CustomXpsAnnotation>(this)?.annotationThumb;
                return thumb != null
                    ? new Rect(Annotation.PositionX, Annotation.PositionY, thumb.ActualWidth, thumb.ActualHeight)
                    : new Rect(Annotation.PositionX, Annotation.PositionY, 10, 10);
            }
        }
    }
}
