﻿using Ascon.Pilot.SDK;
using System.ComponentModel.Composition;
using System.IO;
using OpenHtmlToPdf;

namespace HtmlRenderer
{
    [Export(typeof(IHtmlRenderer))]
    public class HtmlRenderer : IHtmlRenderer
    {
        public void RenderBody(string htmlBody, string outputPath)
        {
            var pdfBytes = Pdf
                .From(htmlBody)
                .WithObjectSetting("web.defaultEncoding", "utf-8")
                .Content();

            File.WriteAllBytes(outputPath, pdfBytes);
        }
    }
}
