/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Controls;

namespace DocumentsExplorerDetailsViewSample
{
    class TypeDetailsViewModel : PropertyChangedBase
    {
        private string _name;
        private string _title;

        public TypeDetailsViewModel(IType type)
        {
            Name = type.Name;
            Title = type.Title;
        }

        public string Title
        {
            get => _title;
            set
            {
                _title = value;
                NotifyOfPropertyChange(nameof(Title));
            }
        }

        public string Name
        {
            get => _name;
            set
            {
                _name = value;
                NotifyOfPropertyChange(nameof(Name));
            }
        }
    }
}
