﻿using System.Text;
using PdfStamper.Models;

namespace PdfStamper.Extensions
{
    public static class BaseSettingModelExtensions
    {
        public static bool IsValid(this BaseSettingModel model, out string errors)
        {
            errors = null;

            var errorsBuilder = new StringBuilder();
            if (model.OffsetPreviousX < 0)
                errorsBuilder.AppendLine("Offset from previous by X coordinate must be grater or equal to zero");

            if (model.OffsetPreviousY < 0)
                errorsBuilder.AppendLine("Offset from previous by Y coordinate must be grater or equal to zero");

            if (model.OffsetX < 0)
                errorsBuilder.AppendLine("Offset by X coordinate must be be grater or equal to zero");

            if (model.OffsetY < 0)
                errorsBuilder.AppendLine("Offset by Y coordinate must be be grater or equal to zero");

            if (model.PageNumber <= 0)
                errorsBuilder.AppendLine("Page number must be grater than zero");

            if (errorsBuilder.Length <= 0)
                return true;

            errors = errorsBuilder.ToString();
            return false;
        }
    }
}