﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
namespace PdfStamper.Models
{
    public class BaseSettingModel
    {
        public BaseSettingModel(SettingType settingType)
        {
            SettingType = settingType;
        }

        public SettingType SettingType { get; }
        public Position Position { get; set; }
        public int OffsetX { get; set; }
        public int OffsetY { get; set; }
        public int PageNumber { get; set; }
        public bool IsOnLastPage { get; set; }
        public int OffsetPreviousX { get; set; }
        public int OffsetPreviousY { get; set; }
        public bool PutStamp { get; set; }
    }

    public enum SettingType
    {
        Signature,
        IntoProduction
    }

    public enum Position
    {
        LeftTop = 0,
        RightTop = 1,
        LeftBottom = 2,
        RightBottom = 3
    }
}