﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
namespace PdfStamper.Models
{
    public class IntoProductionSettingModel : BaseSettingModel
    {
        public IntoProductionSettingModel() : base(SettingType.IntoProduction) { }

        public string ProductionRole { get; set; }

        public static IntoProductionSettingModel GetDefault()
        {
            return new IntoProductionSettingModel
            {
                ProductionRole = Properties.Resources.DefaultProductionRole,
                Position = Position.LeftBottom,
                OffsetX = 70,
                OffsetY = 125,
                IsOnLastPage = true,
                PageNumber = 1,
                OffsetPreviousX = 0,
                OffsetPreviousY = 30,
                PutStamp = true
            };
        }
    }
}