﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PdfStamper.Resources;

namespace PdfStamper.Models
{
    public class SignatureSettingModel : BaseSettingModel
    {
        public SignatureSettingModel() : base(SettingType.Signature) { }

        public byte[] Image { get; set; }
        public string StampHeader { get; set; }

        public static SignatureSettingModel GetDefault()
        {
            return new SignatureSettingModel
            {
                Image = EmbeddedResources.GetEmbeddedImage("logo.png"),
                StampHeader = Properties.Resources.DefaultStampHeader,
                Position = Position.LeftBottom,
                OffsetX = 70,
                OffsetY = 125,
                IsOnLastPage = true,
                PageNumber = 1,
                OffsetPreviousX = 0,
                OffsetPreviousY = 30,
                PutStamp = true
            };
        }
    }
}