﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Ascon.Pilot.SDK;
using System;
using System.IO;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using PdfStamper.Models;
using PdfStamper.Serializing;

namespace PdfStamper
{
    public class Tools
    {
        public static IFilesSnapshot GetFilesSnapshot(IDataObject document, DateTime? documentVersion)
        {
            if (documentVersion == null)
                return document.ActualFileSnapshot;

            var snapshots = new List<IFilesSnapshot> { document.ActualFileSnapshot };
            snapshots.AddRange(document.PreviousFileSnapshots);

            return snapshots.FirstOrDefault(snapshot => snapshot.Created.Ticks.Equals(documentVersion.Value.Ticks));
        }

        public static Stream GetStreamFromStampData(StampPosition stampPosition)
        {
            var newDataString = Serializer.SerializeToJson(stampPosition);
            var data = Encoding.UTF8.GetBytes(newDataString);
            var stream = new MemoryStream();
            stream.Write(data, 0, data.Length);
            return stream;
        }

        public static byte[] StreamToArray(Stream stream)
        {
            var origPos = stream.Position;

            try
            {
                using (var ms = new MemoryStream())
                {
                    stream.CopyTo(ms);
                    ms.Position = 0;
                    return ms.ToArray();
                }
            }
            finally
            {
                stream.Position = origPos;
            }
        }
    }
}
