/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;
using ProjectCloneWizard.Data;

namespace ProjectCloneWizard.Common
{
    static class DataTypeExtensions
    {
        public static bool IsFolder(this IType type)
        {
            return type.Name == SystemTypeNames.PROJECT_FOLDER;
        }

        public static bool IsEcmDocument(this IType type)
        {
            return type.IsMountable && type.HasFiles;
        }
    }
}
