/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;
using Ascon.Pilot.Themes;

namespace ProjectCloneWizard.Common
{
    public interface IIconsProvider
    {
        byte[] GetCopyStructureHereIcon();
        byte[] GetCopyStructureIcon();
        byte[] GetPasteStructureIcon();
    }

    [Export(typeof(IIconsProvider))]
    class IconsProvider : IIconsProvider
    {
        private readonly IPilotDialogService _pilotDialogService;

        [ImportingConstructor]
        public IconsProvider(IPilotDialogService pilotDialogService)
        {
            _pilotDialogService = pilotDialogService;
        }

        public byte[] GetCopyStructureHereIcon()
        {
            return GetIcon("menu_icon_dark.svg", "menu_icon_light.svg");
        }

        public byte[] GetCopyStructureIcon()
        {
            return GetIcon("content-copy_dark.svg", "content-copy_light.svg");
        }

        public byte[] GetPasteStructureIcon()
        {
            return GetIcon("content-paste_dark.svg", "content-paste_light.svg");
        }

        private byte[] GetIcon(string darkName, string lightName)
        {
            var icon = darkName;
            if (_pilotDialogService.Theme == ThemeNames.Jedi)
                icon = lightName;

            return IconLoader.GetIcon(icon);
        }
    }
}
