﻿using Ascon.Pilot.SDK;
using System.Text;

namespace ProjectCloneWizard
{
    public static class DataObjectExtentions
    {
        public static string GetTitle(this IDataObject dataObject)
        {
            var type = dataObject.Type;
            if (dataObject.Attributes.ContainsKey(SystemAttributeNames.SMART_FOLDER_TITLE))
            {
                return dataObject.Attributes[SystemAttributeNames.SMART_FOLDER_TITLE].ToString();
            }

            if (dataObject.Id == SystemObjectIds.RootObjectId)
                return type.Title;

            var sb = new StringBuilder();
            foreach (var attr in type.Attributes)
            {
                var attributeText = GetAttributeText(dataObject, attr);
                if (sb.Length != 0 && !string.IsNullOrEmpty(attributeText))
                {
                    sb.Append(" - ");
                }
                sb.Append(attributeText);
            }
            return sb.ToString();
        }

        private static string GetAttributeText(IDataObject dataObject, IAttribute attr)
        {
            if (attr.Type == AttributeType.Numerator)
            {
                return string.Empty;
            }

            object value;
            dataObject.Attributes.TryGetValue(attr.Name, out value);
            var strValue = value?.ToString();

            if (attr.Name == SystemAttributeNames.PROJECT_ITEM_NAME)
                return strValue;

            if (attr.ShowInObjectsExplorer)
                return strValue;

            return string.Empty;
        }

    }
}
