/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Collections.Generic;
using ProjectCloneWizard.Tools;

namespace ProjectCloneWizard.ObjectsTree
{
    class NodeViewModelComparer : IComparer<NodeViewModel>
    {
        private readonly int _direction;

        public NodeViewModelComparer(bool ascending = true)
        {
            _direction = ascending ? 1 : -1;
        }

        public int Compare(NodeViewModel x, NodeViewModel y)
        {
            return DoCompare(x, y);
        }

        public int DoCompare(NodeViewModel x, NodeViewModel y)
        {
            var result = x.Type.Sort.CompareTo(y.Type.Sort);
            if (result != 0)
                return result;

            result = NaturalComparer.Compare(x.Title, y.Title);
            if (result != 0)
                return _direction * result;

            return _direction * (x.GetHashCode() - y.GetHashCode());
        }
    }
}
