/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Windows;
using System.Windows.Controls;

namespace ProjectCloneWizard.ObjectsTree
{
    /// <summary>
    /// Interaction logic for ObjectsTreeControl.xaml
    /// </summary>
    public partial class ObjectsTreeControl : UserControl
    {
        public static readonly DependencyProperty AllowCheckingProperty =
            DependencyProperty.Register("AllowChecking", typeof(bool), typeof(ObjectsTreeControl), new PropertyMetadata(false));

        public ObjectsTreeControl()
        {
            InitializeComponent();
        }

        public bool AllowChecking
        {
            get { return (bool)GetValue(AllowCheckingProperty); }
            set { SetValue(AllowCheckingProperty, value); }
        }

        private void TreeView_OnSelectedItemChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            var viewModel = (ObjectsTreeViewModel)DataContext;
            viewModel.SelectedItem = (NodeViewModel)e.NewValue;
        }
    }
}
