/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ProjectCloneWizard.Common;

namespace ProjectCloneWizard.ViewModels
{
    class FinishPageViewModel : PropertyChangedBase
    {
        private readonly CreationInfo _creationInfo;
        private string _result;
        private string _error;

        public FinishPageViewModel(CreationInfo creationInfo)
        {
            _creationInfo = creationInfo;
        }

        public string Result
        {
            get { return _result; }
            set
            {
                _result = value;
                NotifyOfPropertyChanged(() => Result);
            }
        }

        public string Error
        {
            get { return _error; }
            set
            {
                _error = value;
                NotifyOfPropertyChanged(() => Error);
            }
        }

        public void Load()
        {
            if (_creationInfo.Exception != null)
            {
                Result = "В процессе создания элемента произошла ошибка";
                Error = _creationInfo.Exception.Message;
                //Error += _creationInfo.Exception.StackTrace;
                return;
            }

            Result = "Элемент создан успешно";
        }
    }
}
