/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Policy;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Extensions;
using ProjectCloneWizard.Common;
using ProjectCloneWizard.Data;
using ProjectCloneWizard.ObjectsTree;

namespace ProjectCloneWizard.ViewModels
{
    class UpdateStructProcessPageViewModel : ProcessPageViewModel
    {
        public UpdateStructProcessPageViewModel(CreationInfo creationInfo, IObjectModifier modifier, IObjectsRepository repository, IFileProvider fileProvider) 
            : base(creationInfo, modifier, repository, fileProvider)
        {
        }

        protected override async Task<bool> Process(IEnumerable<IDataObject> templateObjects)
        {
            Progress = "Загрузка всех детей выбранного элемента";
            var children = await _repository.GetObjectsAsync(_creationInfo.Parent.Children, CancellationToken.None);
            var projectChildrenTitles = children.Select(x => x.GetTitle()).ToList();

            return await Task<bool>.Factory.StartNew(() => 
            {
                //Create project
                _idMap.Add(_creationInfo.Template.Id, _creationInfo.Parent.Id);

                var objectList = new List<NodeViewModel>();
                FillNodeList(_creationInfo.ObjectsNodes, objectList);

                var storageList = new List<NodeViewModel>();
                FillNodeList(_creationInfo.StorageNodes, storageList);

                var result = false;
                foreach (var dataObject in templateObjects)
                {
                    _cts.Token.ThrowIfCancellationRequested();

                    if (dataObject.Id == _creationInfo.Template.Id)
                        continue;

                    var templateTitle = dataObject.GetTitle();
                    if (projectChildrenTitles.Contains(templateTitle))
                        continue;

                    //если есть в списке и установлен IsChecked создаем
                    var node = objectList.FirstOrDefault(n => n.Id == dataObject.Id);
                    if (node != null && node.IsChecked)
                        result = CreateObjectClone(dataObject, _creationInfo.CopyAccessForObjects);

                    var storageNode = storageList.FirstOrDefault(n => n.Id == dataObject.Id);
                    if (storageNode != null && storageNode.IsChecked)
                    {
                        if (storageNode.Type.IsEcmDocument())
                            continue;

                        result = CreateObjectClone(dataObject, _creationInfo.CopyAccessForFiles);
                    }

                }
                return result;
            }, _cts.Token);
        }
    }
}
