/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
#pragma warning disable 67

namespace ShowObjectsTree.Async
{
    public class Node : INotifyPropertyChanged
    {
        public Node(Guid id, string title, byte[] icon, IList<Guid> children)
        {
            Id = id;
            Title = title;
            Icon = icon;
            Subnodes = new ObservableCollection<Node>();
            Children = new ReadOnlyCollection<Guid>(children);
        }

        public Guid Id { get; private set; }
        public string Title { get; private set; }
        public byte[] Icon { get; private set; }
        public ObservableCollection<Node> Subnodes { get; private set; }
        public ReadOnlyCollection<Guid> Children { get; private set; }
        public event PropertyChangedEventHandler PropertyChanged;
    }
}