/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Windows.Threading;
using Ascon.Pilot.SDK;
using Ascon.Pilot.SDK.Menu;

namespace ShowObjectsTree.DynamicData
{
    [Export(typeof(IMenu<ObjectsViewContext>))]
    public class ObjectContextMenuHandler : IMenu<ObjectsViewContext>
    {
        private const string SHOW_OBJECTS_TREE_MENU_ITEM_NAME = "Show_Objects_Tree";
        private readonly IObjectsRepository _repository;

        [ImportingConstructor]
        public ObjectContextMenuHandler(IObjectsRepository repository)
        {
            _repository = repository;
        }

        public void Build(IMenuBuilder builder, ObjectsViewContext context)
        {
            if(context.IsContext)
                return;

            var item = builder.AddItem(SHOW_OBJECTS_TREE_MENU_ITEM_NAME, builder.Count);
            item.WithHeader("Show Objects Tree");
        }

        public void OnMenuItemClick(string name, ObjectsViewContext context)
        {
            if (name == SHOW_OBJECTS_TREE_MENU_ITEM_NAME)
            {
                var selectedIds = context.SelectedObjects.Select(x => x.Id).ToList();
                Dispatcher.CurrentDispatcher.BeginInvoke(new Action(() => ShowObjectsTree(selectedIds)));
            }
        }

        private void ShowObjectsTree(IEnumerable<Guid> ids)
        {
            var view = new ObjectsTree();
            var viewModel = new ObjectsTreeViewModel(_repository);
            viewModel.Load(ids);
            view.DataContext = viewModel;
            view.Show();
        }
    }
}
