Ascon Pilot Server SDK
===

## Содержание
[Интерфейсы](#interfaces)
- [Авторизация и аутентификация IAuthentication](#IAuthenticationApi)
	 - [IAuthenticationApi.Login](#loginMethod)
	 - [IAuthenticationApi.GetlicenseInformation](#GetLicenseInformationMethod)
     - [IAuthenticationApi.ConsumeLicense](#ConsumeLicenseMethod)
     - [IAuthenticationApi.ReleaseLicense](#ReleaseLicenseMethod)
     - [Список используемых типов лицензий](#licenseTypes)
- [Работа с объектами и метаданными IServerApi](#IServerApi)
	 - [IServerApi.OpenDatabase](#OpenDatabase)
	 - [IServerApi.GetDatabase](#GetDatabase)
	 - [IServerApi.GetMetadata](#GetMetadata)
	 - [IServerApi.GetSettings](#GetSettings)
	 - [IServerApi.ChangeSettings](#ChangeSettings)
	 - [IServerApi.GetObjects](#GetObjects)
	 - [IServerApi.GetChangesets](#GetChangesets)
	 - [IServerApi.Change](#Change)
	 - [IServerApi.LoadPeople](#LoadPeople)
	 - [IServerApi.LoadPeopleByIds](#LoadPeopleByIds)
	 - [IServerApi.LoadOrganisationUnits](#LoadOrganisationUnits)
	 - [IServerApi.LoadOrganisationUnitsByIds](#LoadOrganisationUnitsByIds)
	 - [IServerApi.AddSearch](#AddSearch)
	 - [IServerApi.RemoveSearch](#RemoveSearch)
	 - [IServerApi.GeometrySearch](#GeometrySearch)
	 - [IServerApi.ContentSearch](#ContentSearch)
	 - [IServerApi.UpdatePerson](#UpdatePerson)
	 - [IServerApi.UpdateOrganisationUnit](#UpdateOrganisationUnit)
- [Работа с сообщениями и чатам IMessagesApi](#IMessagesApi)
- [Подписка на события и изменения IEventsApi](#IEventsApi)
	 - [IEventsApi.SubscribeChanges](#SubscribeMethod)
	 - [IEventsApi.GetMissedChanges](#MissedChangesMethod)
	 - [IEventsApi.AcceptChange](#AcceptChangeMethod)
- [Интерфейс обратного вызова Server API IServerCallback](#IServerCallback) 
	 - [IServerCallback.NotifyChangeset](#NotifyChangeset)
	 - [IServerCallback.NotifyOrganisationUnitChangeset](#NotifyOrganisationUnitChangeset)
	 - [IServerCallback.NotifyPersonChangeset](#NotifyPersonChangeset)
	 - [IServerCallback.NotifyDMetadataChangeset](#NotifyDMetadataChangeset)
	 - [IServerCallback.NotifySearchResult](#NotifySearchResult)
	 - [IServerCallback.NotifyGeometrySearchResult](#NotifyGeometrySearchResult)
	 - [IServerCallback.NotifyDNotificationChangeset](#NotifyDNotificationChangeset)
	 - [IServerCallback.NotifyCommandResult](#NotifyCommandResult)
- [Регистрация API для обработки пользовательских команд IServerCommandApi](#IServerCommandApi)
	 - [IServerCommandApi.RegisterCommandHandler](#RegisterCommandHandler)
	 - [IServerCommandApi.PublishCommandResult](#PublishCommandResult)
- [Интерфейс обратного вызова Messages API IMessageCallback](#IMessageCallback) 
	 - [IMessageCallback.NotifyMessageCreated](#NotifyMessageCreated)
	 - [IMessageCallback.NotifyTypingMessage](#NotifyTypingMessage)
	 - [IMessageCallback.CreateNotification](#CreateNotification)
	 - [IMessageCallback.NotifyOnline](#NotifyOnline)
	 - [IMessageCallback.NotifyOffline](#NotifyOffline)
	 - [IMessageCallback.UpdateLastMessageDate](#UpdateLastMessageDate)
- [Работа с поисковыми запросами IQueryBuilder](#IQueryBuilder)

[Списки полей объектов](#fields)
- [LicenseDataEx](#LicenseDataEx)
- [LicenseData](#LicenseData)
- [OrganisationInfo](#OrganisationInfo)
- [License](#License)
- [Request](#Request)
- [Product](#Product)
- [DDatabaseInfo](#DDatabaseInfo)
- [DChangeset](#DChangeset)
- [DPerson](#DPerson)
- [DMetadata](#DMetadata)
- [DSettings](#DSettings)
- [DSettingsChange](#DSettingsChange)
- [DObject](#DObject)
- [DChangeset](#DChangeset)
- [DChangesetData](#DChangesetData)
- [DOrganisationUnit](#DOrganisationUnit)
- [DGeometrySearchDefinition](#DGeometrySearchDefinition)
- [DPersonUpdateInfo](#DPersonUpdateInfo)
- [DOrganisationUnitUpdateInfo](#DOrganisationUnitUpdateInfo)
- [DRule](#DRule)
- [IServerCallback](#IServerCallback)
- [ServerCommandResult](#ServerCommandResult)
- [DMessage](#DMessage)
- [DChatInfo](#DChatInfo)
- [NotifiableDChatInfo](#NotifiableDChatInfo)
- [DChatMember](#DChatMember)
- [DSearchDefinition](#DSearchDefinition)
- [DSearchRequest](#DSearchRequest)

<a name="interfaces"/>
Интерфейсы
----------
Для получения серверных интерфейсов используется объект HttpPilotClient, у которого предварительно необходимо вызвать метод Connect(bool isCheckClientVersion = true).

<a name="IAuthenticationApi"/>
### Интерфейс IAuthenticationApi ###
Интерфейс авторизации. Авторизоваться необходимо перед использованием интерфейсов **IMessagesApi**, **IServerApi** и **IFileArchiveApi**,  **IEventsApi**.
Для получения IAuthenticationApi необходимо вызвать метод HttpPilotClient.GetAuthenticationApi()
<a name="loginMethod"/>
##### IAuthenticationApi.Login #####

Метод авторизации пользователя.

```cpp
void IAuthenticationApi.Login(string databaseName, string login, string protectedPassword, bool useWindowsAuth, int licenseType);
```
где:
 - `databaseName` - имя базы данных.
 - `login` - логин пользователя
 - `protectedPassword` - пароль, зашифрованный с помощью Advanced Encryption Standard
 - `useWindowsAut` - признак использования windows авторизации
 - `licenseType` - тип лицензии


<a name="GetLicenseInformationMethod"/>
##### IAuthenticationApi.GetLicenseInformation #####

Метод возвращает сериализованную в XML информацию о лицензии **LicenseDataEx**.

```cpp
byte[] GetLicenseInformation()
```
<a name="ConsumeLicenseMethod"/>
##### IAuthenticationApi.ConsumeLicense #####

Захватывает одну лицензию на сервере.
```cpp
 void ConsumeLicense(int licenseType);
```
где - `licenseType` - тип лицензии.

<a name="ReleaseLicenseMethod"/>
##### IAuthenticationApi.ReleaseLicense #####

Отпускает одну лицензию на сервере.
```cpp
 void ReleaseLicense(int licenseType);
```
где - `licenseType` - тип лицензии.
<a name="licenseTypes"/>
#####Список используемых типов лицензий#####
```cpp
public const int PILOT_ICE = 100;
public const int PILOT_ECM = 101;
public const int PILOT_STORAGE = 102;
public const int PILOT_ENTERPRISE = 103;
public const int RENGA_ARCHITECTURE = 104;
public const int RENGA_STRUCTURE = 105;
public const int _8D = 106;
public const int _8D_PROF = 107;
public const int RENGA_MEP = 108;
```

<a name="IServerApi"/>
### Работа с объектами и метаданными (IServerApi )###
для получения IServerApi необходимо вызвать  метод HttpPilotClient.GetServerApi(IServerCallback callback)

<a name="OpenDatabase"/>
##### IServerApi.OpenDatabase #####

Открывает базу данных, регистрирует методы обратного вызова и возвращает описание базы данных **DDatabaseInfo**.
```cpp
DDatabaseInfo OpenDatabase();
```

<a name="GetDatabase"/>
##### IServerApi.GetDatabase #####

Метод возвращает описание базы данных.

```cpp
DDatabaseInfo GetDatabase(string database)
```
где:
 - `database` - имя базы данных.

<a name="GetMetadata"/>
##### IServerApi.GetMetadata #####

Получить текущие метаданные.

```cpp
DMetadata GetMetadata(long localVersion)
```
где:
 - `localVersion` - текущая версия метаданных на клиенте.

<a name="GetSettings"/>
##### IServerApi.GetSettings #####

Получение значений настроек. Если параметр loadAll равен true, будут получены настройки всех пользователей. Требуются права администратора.

```cpp
DSettings GetSettings(long loadAll)
```
где:
 - `loadAll` - признак необходимости получения настроек всех пользователей.

<a name="ChangeSettings"/>
##### IServerApi.ChangeSettings #####

Изменение значений настроек. Для изменения значений обобщенных настроек требуются права администратора.

```cpp
void ChangeSettings(DSettingsChange change);
```
где:
 - `change` - изменение.

<a name="GetObjects"/>
##### IServerApi.GetObjects #####

Получить объекты.

```cpp
List<DObject> GetObjects(Guid[] ids);
```
где:
 - `ids` - список идентификаторов объектов.

<a name="GetChangesets"/>
##### IServerApi.GetChangesets #####

Получить изменения.

```cpp
List<DChangeset> GetChangesets(long first, long last);
```
где:
 - `first` - начало возвращаемого промежутка идентификаторов изменений.
 - `second`- окончание возвращаемого промежутка идентификаторов изменений.

<a name="Change"/>
##### IServerApi.Change #####

Применить изменения объектов.
Вовзращает изменения, слитые с изменениями от других клиентов.
```cpp
DChangeset Change(DChangesetData changes);
```
где:
 - `changes` - изменения

<a name="LoadPeople"/>
##### IServerApi.LoadPeople #####

 Загрузить всех пользователей базы данных
```cpp
List<DPerson> LoadPeople();
```

<a name="LoadPeopleByIds"/>
##### IServerApi.LoadPeopleByIds #####

 Получить список пользователей по идентификаторам.
```cpp
 List<DPerson> LoadPeopleByIds(int[] ids);
```
где:
 - `ids` - идентификаторы пользователей

<a name="LoadOrganisationUnits"/>
##### IServerApi.LoadOrganisationUnits #####

 Получить список организационных единиц
```cpp
 List<DOrganisationUnit> LoadOrganisationUnits();
```
<a name="LoadOrganisationUnitsByIds"/>
##### IServerApi.LoadOrganisationUnitsByIds #####

Получить список организационных единиц по идентификаторам.
```cpp
List<DOrganisationUnit> LoadOrganisationUnitsByIds(int[] ids);
```
где:
 - `ids` - идентификаторы организационных единиц

<a name="AddSearch"/>
##### IServerApi.AddSearch #####

Добавить условие поиска.
```cpp
  void AddSearch(DSearchDefinition searchDefinition);
```
где:
 - `searchDefinition` - условия поиска

<a name="RemoveSearch"/>
##### IServerApi.RemoveSearch #####

 Удалить условие поиска.
```cpp
 void RemoveSearch(Guid searchDefinitionId);
```
где:
 - `searchDefinitionId` - идентификатор условий поиска

<a name="GeometrySearch"/>
##### IServerApi.GeometrySearch #####

Запустить поиск по геометрии.
```cpp
 void GeometrySearch(DGeometrySearchDefinition searchDefinition);
```
где:
 - `searchDefinition` - условия поиска

<a name="ContentSearch"/>
##### IServerApi.ContentSearch #####

Запустить поиск по файлам.
```cpp
void ContentSearch(DSearchDefinition searchDefinition);
```
где:
 - `searchDefinition` - условия поиска

<a name="UpdatePerson"/>
##### IServerApi.UpdatePerson #####

Обновить информацию о пользователе.
```cpp
 void UpdatePerson(DPersonUpdateInfo updateInfo);
```
где:
 - `updateInfo` - изменения

<a name="UpdateOrganisationUnit"/>
##### IServerApi.UpdateOrganisationUnit #####

Обновить информацию о должности.
```cpp
 void UpdateOrganisationUnit(DOrganisationUnitUpdateInfo updateInfo);
```
где:
 - `updateInfo` - изменения

 <a name="IMessagesApi"/>
### Интерфейс IMessagesApi ###
Интерфейс для работы с сообщениями и чатами.
<a name="Open"/>
##### IMessagesApi.Open #####

Метод, возвращающий через методы обратного вызова уведомления для сообщений, которые были отправлены, пока залогиненый пользователь был оффлайн.

```cpp
 void Open(int maxNotificationCount, DateTime selectFromDate);
```
где:
 - `maxNotificationCount` - максимальное число уведомлений. Если это число превышено, будет отправлено агрегирующее уведомление
 - `selectFromDate` - дата создания сообщения, начиная с которой сообщения будут отправлены как нотификация 

<a name="SendMessage"/>
##### IMessagesApi.SendMessage #####

Отправляет сообщение. Возвращает время создания сообщения на сервере

```cpp
DateTime SendMessage(DMessage message);
```
где:
 - `message` - сообщение
 
<a name="GetNotifiableChats"/>
##### IMessagesApi.GetNotifiableChats #####

Возвращает первые N чатов, отсортированные по дате последнего сообщения

```cpp
List<NotifiableDChatInfo> GetNotifiableChats(int personId, DateTime fromDateTimeServer, DateTime toDateTimeServer, int topN, bool skipObjectRelated = true);
```
где:
 - `personId` - идентификатор пользователя. Должен совпадать с залогиненым пользователем
 - `fromDateTimeServer` - начало временного промежутка
 - `toDateTimeServer` - окончание временного промежутка
 - `topN` - количество чатов
 - `skipObjectRelated` - указывает на необходимость пропускать чаты типа `ObjectRelated`
 
<a name="GetChats"/>
##### IMessagesApi.GetChats #####

Возвращает первые N чатов, отсортированные по дате последнего сообщения

```cpp
 List<DChatInfo> GetChats(int personId, DateTime fromDateTimeServer, DateTime toDateTimeServer, int topN, bool skipObjectRelated = true);
```
где:
 - `personId` - идентификатор пользователя. Должен совпадать с залогиненым пользователем
 - `fromDateTimeServer` - начало временного промежутка
 - `toDateTimeServer` - окончание временного промежутка
 - `topN` - количество чатов
 - `skipObjectRelated` - указывает на необходимость пропускать чаты типа `ObjectRelated`
 
<a name="GetNotifiableChat"/>
##### IMessagesApi.GetNotifiableChat #####

Получить информацию о чате

```cpp
 NotifiableDChatInfo GetNotifiableChat(Guid chatId);
```
где:
 - `chatId` - идентификатор чата
 
  <a name="GetChat"/>
##### IMessagesApi.GetChat #####

Получить информацию о чате

```cpp
DChatInfo GetChat(Guid chatId);
```
где:
 - `chatId` - идентификатор чата

  <a name="CheckIsOnline"/>
##### IMessagesApi.CheckIsOnline #####

Проверяет пользователя на онлайн

```cpp
bool CheckIsOnline(int personId);
```
где:
 - `personId` - идентификатор пользователя
 
<a name="GetPersonalChat"/>
##### IMessagesApi.GetPersonalChat #####

 Получить информацию о персональном чате залогиненого пользователя c другим участником

```cpp
DChatInfo GetPersonalChat(int personId);
```
где:
 - `personId` - идентификатор пользователя
 
<a name="GetNotifiablePersonalChat"/>
##### IMessagesApi.GetNotifiablePersonalChat #####

 Получить информацию о персональном чате залогиненого пользователя c другим участником

```cpp
DChatInfo GetNotifiablePersonalChat(int personId);
```
где:
 - `personId` - идентификатор пользователя
 
  
<a name="GetChatCreationMessage"/>
##### IMessagesApi.GetChatCreationMessage #####

Получить сообщение о создании чата

```cpp
DMessage GetChatCreationMessage(Guid chatId);
```
где:
 - `chatId` - идентификатор чата
 
<a name="GetChatMembers"/>
##### IMessagesApi.GetChatMembers #####

 Получить список участников чата, измененный после `fromDateUtc`

```cpp
List<DChatMember> GetChatMembers(Guid chatId, DateTime fromDateUtc);
```
где:
 - `chatId` - идентификатор чата
 - `fromDateUtc` - да, после которой должны быть добавлены или отредактированы возвращаемые участники
 
<a name="GetMessages"/>
##### IMessagesApi.GetMessages #####

Возвращает список сообщений в количестве не большем `maxNumber`
И общее число сообщений, удовлетворяющих условиям.
```cpp
Tuple<List<DMessage>, int> GetMessages(Guid chatId, DateTime dateFromUtc, DateTime dateToUtc, int maxNumber, bool descendingOrder);
```
где:
 - `chatId` - идентификатор чата
 - `dateFromUtc` - дата, после которой должны быть соданы возвращаемые сообщения
 - `dateToUtc` - дата, до которой должны быть соданы возвращаемые сообщения
 - `maxNumber` - максимальное число возвращаемых сообщений
 - `descendingOrder` - порядок сортировки сообщений. True -- в порядке убывания серверной даты. False -- в порядке возрастания
 
<a name="GetLastUnreadMessage"/>
##### IMessagesApi.GetLastUnreadMessage #####

 Возвращает самое ранее непрочитанное сообщения в чате

```cpp
DMessage GetLastUnreadMessage(Guid chatId);
```
где:
 - `chatId` - идентификатор чата

<a name="TypingMessage"/>
##### IMessagesApi.TypingMessage #####

Пользователь печатает сообщение в чат

```cpp
void TypingMessage(Guid chatId);
```
где:
 - `chatId` - идентификатор чата
 
<a name="GetMessagesWithAttachments"/>
##### IMessagesApi.GetMessagesWithAttachments #####

Возвращает сообщения, содержащие вложения

```cpp
  List<DMessage> GetMessagesWithAttachments(Guid chatId, DateTime fromServerDateUtc, DateTime toServerDateUtc, int pageSize);
```
где:
   - `chatId` - идентификатор чата
   - `fromServerDateUtc` - дата, после которой должны быть соданы возвращаемые сообщения
   - `toServerDateUtc` - дата, до которой должны быть соданы возвращаемые сообщения
   - `pageSize` - максимальное количество возвращаемых сообщений
   
<a name="GetRelatedChats"/>
##### IMessagesApi.GetRelatedChats #####

 Возвращает чаты связанные с объектом

```cpp
 List<NotifiableDChatInfo> GetRelatedChats(int personId, Guid objectId, ChatRelationType type);
```
где:
 - `personId` - идентификатор пользователя
 - `objectId` - идентификатор объекта
 - `type` - тип связи
 
<a name="GetThirdPartyMessage"/>
##### IMessagesApi.GetThirdPartyMessage #####

возвращает сообщение, созданное в third party приложении

```cpp
 DMessage GetThirdPartyMessage(string thirdPartyInfo);
```
где:
 - `thirdPartyInfo` - дополнительная информация, которую можно заполнить при создании сообщения
 
<a name="GetMessage"/>
##### IMessagesApi.GetMessage #####

возвращает сообщение по его идентификатору

```cpp
DMessage GetMessage(Guid messageId);
```
где:
 - `messageId` - идентификатор сообщения



 <a name="IEventsApi"/>
### Интерфейс IEventsApi ###
Интерфейс подписки на события и изменения.
<a name="SubscribeMethod"/>
##### IEventsApi.SubscribeChanges #####

Метод подписки на изменения по переданному набору правил.

```cpp
void IEventsApi.SubscribeChanges(IEnumerable<DRule> rules);
```
где:
 - `rules` - список правил.

<a name="MissedChangesMethod"/>
##### IEventsApi.GetMissedChanges #####

Метод получения пропущенных событий, сгруппированных по правилам, которым они удовлетворяют

```cpp
List<Tuple<Guid, DChangesetData[]>> IEventsApi.GetMissedChanges();
```

<a name="AcceptChangeMethod"/>
##### IEventsApi.AcceptChange #####

Метод подтверждения получения изменения от клиента

```cpp
void AcceptChange(Guid changeId, Guid ruleId);
```
где:
 - `changeId` - идентификатор изменения.
 - `changeId` - идентификатор правила, по которому изменение получено.

<a name="IServerCallback"/>
 ### Интерфейс IServerCallback ###
Интерфейс обратного вызова ServerApi.

<a name="NotifyChangeset"/>
##### IServerCallback.NotifyChangeset #####

Метод обратного вызова изменения объектов
```cpp
void IServerCallback.NotifyChangeset(DChangeset changeset);
```
где:
 - `changeset` - изменения над объектами.
 
 <a name="NotifyOrganisationUnitChangeset"/>
##### IServerCallback.NotifyOrganisationUnitChangeset #####

Метод обратного вызова изменения организационных единиц
```cpp
void IServerCallback.NotifyOrganisationUnitChangeset(OrganisationUnitChangeset changeset);
```
где:
 - `changeset` - изменения над орг. единицами.
 
 
 <a name="NotifyPersonChangeset"/>
##### IServerCallback.NotifyPersonChangeset #####

Метод обратного вызова изменения пользователей
```cpp
void IServerCallback.NotifyPersonChangeset(PersonChangeset changeset);
```
где:
 - `changeset` - изменения над пользователями.
 
  <a name="NotifyDMetadataChangeset"/>
##### IServerCallback.NotifyDMetadataChangeset #####

Метод обратного вызова изменения метаданных
```cpp
void IServerCallback.NotifyDMetadataChangeset(DMetadataChangeset changeset);
```
где:
 - `changeset` - изменения метаданных.
 
<a name="NotifySearchResult"/>
##### IServerCallback.NotifySearchResult #####

Метод обратного вызова поискового запроса
```cpp
void IServerCallback.NotifySearchResult(DSearchResult searchResult);
```
где:
 - `searchResult` - результаты поиска. 
 
<a name="NotifyGeometrySearchResult"/>
##### IServerCallback.NotifyGeometrySearchResult #####

Метод обратного вызова поискового запроса по геометрии
```cpp
void IServerCallback.NotifyGeometrySearchResult(DGeometrySearchResult searchResult);
```
где:
 - `searchResult` - результаты поиска.

<a name="NotifyDNotificationChangeset"/>
##### IServerCallback.NotifyDNotificationChangeset #####

Метод обратного вызова нотификации об изменениях
```cpp
void IServerCallback.NotifyDNotificationChangeset(DNotificationChangeset changeset);
```
где:
 - `changeset` - Changeset со списоком сообщений. 

<a name="NotifyCommandResult"/>
##### IServerCallback.NotifyCommandResult #####

Метод обратного вызова результатов выполнения пользовательской команды
```cpp
void IServerCallback.NotifyCommandResult(Guid requestId, byte[] data, ServerCommandResult result);
```
где:
 - `requestId` - id запроса.   
 - `data` - результат выполнения команды.  
 - `result` - тип результата выполнения команды.  

<a name="IServerCommandApi"/>
 ### Интерфейс IServerCommandApi ###
Интерфейс пользовательских команд

<a name="RegisterCommandHandler"/>
##### IServerCommandApi.RegisterCommandHandler #####

 Регистрация клиента как обработчика команд с указанным именем
 ```cpp
void RegisterCommandHandler(string commandName);
```
где:
 - `commandName` - имя команды.
 
<a name="PublishCommandResult"/>
##### IServerCommandApi.PublishCommandResult #####

Публикация результата выполнения команды обработчиком
 ```cpp
void PublishCommandResult(Guid requestId, byte[] data, ServerCommandResult result);
```
где:
 - `requestId` - идентификатор запроса.
 - `data` - результат выполнения команды.
 - `result` - тип результата выполнения команды.

<a name="IMessageCallback"/>
 ### Интерфейс IMessageCallback ###
Интерфейс обратного вызова API сообщений

<a name="NotifyMessageCreated"/>
##### IMessageCallback.NotifyMessageCreated #####

Метод обратного вызова добавляения сообщения
```cpp
void NotifyMessageCreated(NotifiableDMessage message);
```
где:
 - `message` - сообщение

<a name="NotifyTypingMessage"/>
##### IMessageCallback.NotifyTypingMessage #####

функция обратного вызова "пользователь Х печатает сообщение
```cpp
void NotifyTypingMessage(Guid chatId, int personId);
```
где:
 - `chatId` - идентификатор чата
 - `personId` - идентификатор пользователя, печатающего сообщение

<a name="CreateNotification"/>
##### IMessageCallback.CreateNotification #####

функция обратного вызова создания уведомления
```cpp
void CreateNotification(DNotification notification);
```
где:
 - `notification` - уведомление

<a name="NotifyOnline"/>
##### IMessageCallback.NotifyOnline #####

уведомление о выходе пользователя онлайн
```cpp
 void NotifyOnline(int personId);
```
где:
 - `personId` - идентификатор пользователя

<a name="NotifyOffline"/>
##### IMessageCallback.NotifyOffline #####

уведомление об отключении пользователя
```cpp
void NotifyOffline(int personId);
```
где:
 - `personId` - идентификатор пользователя
 
<a name="UpdateLastMessageDate"/>
##### IMessageCallback.UpdateLastMessageDate #####

уведомление об дате последнего полученного сообщения
```cpp
void UpdateLastMessageDate(DateTime maxDate);
```
где:
 - `maxDate` - дата создания сообщения

<a name="IQueryBuilder"/>
 ### Интерфейс IQueryBuilder ###
Интерфейс формирования поисковых запросов

Построение запросов осуществляется с помощью конструкторов запросов `IQueryBuilder`. Основными элементами языка запросов являются так называемые “условия поиска“. Чтобы осуществить поиск необходимо:
- получить конструктор поисковых запросов с помощью одного из статических методов класса `QueryBuilderFactory`: [CreateEmptyQueryBuilder](#CreateEmptyQueryBuilder), [CreateFilesQueryBuilder](#CreateFilesQueryBuilder) или [CreateObjectQueryBuilder](#CreateObjectQueryBuilder).
- построить запрос с помощью полученного конструктора с использованием “условий поиска”.
- выполнить поиск вызвав метод `IServerApi.AddSearch()` передав в качестве параметра экземпляр класса [DSearchDefinition](#DSearchDefinition).

Подробное описание формирования “условий поиска” см. в разделе **Поиск** документации **Client Pilot SDK**.

<a name ="CreateEmptyQueryBuilder"/>
####QueryBuilderFactory.CreateEmptyQueryBuilder()####
Метод получения простого конструктора запросов. Это универсальный конструктор запросов без предварительных условий. Этот конструктор можно использовать для поиска любых объектов в базе, включая объекты системных типов.

<a name ="CreateFilesQueryBuilder"/>
####QueryBuilderFactory.CreateFilesQueryBuilder()####
Метод получения предварительно сконфигурированного конструктора запросов для пользовательских объектов. В результат поисковой выдачи не попадают oбъекты системных и сервисных типов.

<a name ="CreateObjectQueryBuilder"/>
####QueryBuilderFactory.CreateObjectQueryBuilder()####
Метод получения предварительно сконфигурированного конструктора запросов для объектов в состоянии `ObjectState.Alive` или `ObjectState.Frozen`


<a name="fields"/>
####Списки полей объектов####

<a name="LicenseDataEx"/>
#####Список полей **LicenseDataEx**#####
##### IsExpired #####

Содержит признак окончания срока лицензии
```cpp
bool IsExpired { get; }
```

##### IsCheated #####

Содержит признак того, что лицензия невалидна
```cpp
bool IsCheated { get; }
```
##### LicenseData #####

Содержит данные лицензии
```cpp
LicenseData? LicenseData { get; }
```
<a name="LicenseData"/>
#####Список полей **LicenseData**#####
##### Id #####

Идентификатор лицензии
```cpp
Guid Id { get; }
```
##### OrganizationInfo #####

Информация об организации, на которую выдана лицензия
```cpp
OrganizationInfo OrganizationInfo { get; }
```
##### NonCommercialUsage #####

Содержит признак того, что лицензия выдана для некоммерческого использования
```cpp
bool? NonCommercialUsage { get; }
```
##### License #####

Лицензия
```cpp
License License { get; }
```
##### Request #####

Запрос лицензии
```cpp
Request Request { get; }
```
##### Product #####

Наименование продукта
```cpp
string Product { get; }
```
<a name="OrganizationInfo"/>
#####Список полей **OrganizationInfo**#####
##### Name #####

Наименование организации
```cpp
string Name { get; }
```
##### Inn #####

ИНН
```cpp
string Inn { get; }
```
##### Address #####

Адрес
```cpp
string Address { get; }
```
##### ContactInfo #####

Контактная информация
```cpp
string ContactInfo { get; }
```
<a name="License"/>
#####Список полей **License**#####
##### Products #####

Список приложений
```cpp
Product[] Products { get; }
```
##### ValidTo #####

Для комерческой и некомерческой дата окончания получения обновлений.
Для опытной эксплуатации дата окончания действия продукта.
```cpp
DateTime ValidTo{ get; }
```
##### IsTrial #####

Признак лицензии для опытной эксплуатации
```cpp
bool IsTrial{ get; }
```
<a name="Request"/>
#####Список полей **Request**#####
##### Products #####

Список запрашиваемых приложений
```cpp
Product[] Products { get; }
```
##### RequestedMonths #####

Число месяцев, на которое запрашивается лицензия
```cpp
int RequestedMonths { get; }
```
##### IsTrial #####

Признак лицензии для опытной эксплуатации
```cpp
bool IsTrial { get; }
```
<a name="Product"/>
#####Список полей **Product**#####
##### LicenseCode #####

Код лицензии
```cpp
int LicenseCode { get; }
```
##### ProductName #####

Наименование приложения
```cpp
string ProductName { get; }
```
##### Workplaces #####

Количество экземпляров приложения разрешенных лицензией
```cpp
int Workplaces { get; }
```
<a name="DDatabaseInfo"/>
#####Список полей **DDatabaseInfo**#####
##### MetadataVersion #####

Номер версии метаданных
```cpp
long MetadataVersion { get; }
```
##### LastChangeset #####

Последний changeset
```cpp
DChangeset LastChangeset { get; }
```
##### Person #####
Текущий залогиненый пользователь
```cpp
 DPerson Person { get; }
```
##### DatabaseId #####
Идентификатор базы данных
```cpp
 Guid DatabaseId { get; }
```
##### DatabaseVersion #####
Версия базы данных
```cpp
long DatabaseVersion { get; }
```
##### People #####
Версии пользователей
```cpp
Dictionary<int, ushort> People { get; }
```
##### OrganisationUnits #####
Версии элементов организационной структуры
```cpp
Dictionary<int, ushort> OrganisationUnits { get; }
```

<a name="DChangeset"/>
#####Список полей **DChangeset**#####
##### Id #####
Инкрементальный идентификатор изменения
```cpp
long Id { get; }
```
##### Changed #####
Список идентификаторов измененных объектов
```cpp
HashSet<Guid> Changed{ get; }
```
##### Identity #####
Идентификатор изменения
```cpp
HashSet<Guid> Changed{ get; }
```


<a name="DPerson"/>
#####Список полей **DPerson**#####
##### Id #####
Поле Id содержит уникальный идентификатор пользователя.
```cpp
int Id { get; }
```
##### Login #####

Имя пользователя (login).
```cpp
string Login { get; }
```
##### DisplayName #####

Отображаемое имя пользователя. Например ФИО.
```cpp
string DisplayName { get; }
```
##### Comment #####

Комментарий к статусу пользователя.
```cpp
string Comment { get; }
```
##### Sid #####

уникальный идентификатор доменной учетной записи пользователя.
```cpp
string Sid { get; }
```

##### IsDeleted #####

Показывает удален пользователь или нет. В системе *Pilot* информация пользователях не удаляется из базы данных. Пользователи помечаются как удаленные.
```cpp
bool IsDeleted { get; }
```
##### IsAdmin #####

Показывает является ли текущий пользователь администратором.
```cpp
bool IsAdmin { get; }
```
##### UidDn #####

Идентификатор пользователя из LDAP.
```cpp
string UidDn { get; }
```
##### Email #####

Email пользователя.
```cpp
string Email { get; }
```
##### Version #####

Порядковый номер изменения пользователя.
```cpp
ushort Version { get; }
```
##### IsInactive #####

Статус активности пользователя.
```cpp
bool IsInactive { get; }
```
##### Positions #####

Список идентификаторов должностей, которые в данный момент занимает пользователь.
```cpp
List<int> Positions { get; }
```
##### BossOf #####

Список идентификаторов организационных элементов, на которых пользователь в данный момент является руководителем.
```cpp
List<int> BossOf { get; }
```

##### AllOrgUnits #####

Список идентификаторов организационных элементов, на которые назначен пользователь.
```cpp
HashSet<int> AllOrgUnits { get; }
```

<a name="DMetadata"/>
#####Список полей **DMetadata**#####
##### Version #####
Номер версии метаданных
```cpp
long Version { get; set; }
```
##### Types #####
Список типов
```cpp
 List<MType> Types { get; }
```
##### UserStates #####
Список состояйние пользователей
```cpp
 List<MUserState> UserStates { get; }
```

<a name="DSettings"/>
#####Список полей **DSettings**#####
##### PersonalSettings #####
Персональные настройки
```cpp
Dictionary<int, DSettingsCollection> PersonalSettings { get; private set; }
```
##### CommonSettings #####
Общие настройки
```cpp
Dictionary<int, DSettingsCollection> CommonSettings { get; private set; }
```
<a name="DSettingsChange"/>
#####Список полей **DSettingsChange**#####
##### Identity #####
Идентификатор настройки
```cpp
Guid Identity { get; set; }
```
##### OrgUnitId #####
Идентификатор организационной единицы, на которую распространяется настройка. Если значение -1, значит распространяется на конкретного пользователя
```cpp
int OrgUnitId { get; set; }
```
##### PersonId #####
Идентификатор пользователя, на которого распространяется настройка. Если значение -1, значит распространяется на организационную единицу
```cpp
int PersonId { get; set; }
```
##### Key #####
Наименование настройки
```cpp
string Key { get; set; }
```
##### Value #####
значение настройки
```cpp
string Value { get; set; }
```


<a name="DObject"/>
#####Список полей **DObject**#####
##### Id #####
Идентификатор объекта
```cpp
Guid Id { get; set; }
```
##### TypeId #####
Тип объекта
```cpp
int TypeId { get; set; }
```
##### ParentId #####
Идентификатор родительского объекта
```cpp
Guid ParentId { get; set; }
```
##### LastChange #####
Идентификатор последнего изменения объекта
```cpp
long LastChange { get; set; }
```
##### LastChange #####
Идентификатор последнего изменения объекта
```cpp
long LastChange { get; set; }
```

<a name="DRule"/>
#####Список полей **DRule**#####
##### Id #####
Идентификатор правила
```cpp
Guid Id { get; set; }
```
##### ChangeType #####
Тип изменения
```cpp
ChangeType ChangeType { get; set; }
```
##### FileExtension #####
Расширение файла
```cpp
string FileExtension { get; set; }
```

<a name="changeTypes"/>
#####Список типов изменений#####
```cpp
 Create = 1
 Update = 2
 Delete = 3
```

<a name="ServerCommandResult"/>
#####Результат выполениния пользовательской команды#####
```cpp
 Success,
 Error
```

<a name="DMessage"/>
#####Список полей **DMessage**#####
##### Id #####
Идентификатор сообщения
```cpp
Guid Id { get; set; }
```
##### Data #####
Сериализованные протобаф данные сообщения
```cpp
public byte[] Data { get; set; }
```
##### CreatorId #####
Создатель сообщения
```cpp
public int CreatorId { get; set; }
```
##### ServerDate #####
Серверная дата создания сообщения в UTC
```cpp
public DateTime? ServerDate { get; set; }
```
##### LocalDate #####
Клиентская дата создания сообщения в UTC
```cpp
public DateTime LocalDate { get; set; }
```
##### ChatId #####
Идентификатор чата
```cpp
 public Guid ChatId { get; set; }
```
##### RelatedMessageId #####
Идентифкатор сообщения, к которому привязано данное
```cpp
public Guid? RelatedMessageId { get; set; }
```
##### Type #####
Тип сообщения
```cpp
public MessageType Type { get; set; }
```
##### RelatedMessages #####
Список сообщения, связанных с данным
```cpp
public List<DMessage> RelatedMessages { get; set; }
```
<a name="DChatInfo"/>
#####Список полей **DChatInfo**#####
##### Chat #####
Чат
```cpp
public DChat Chat { get; set; }
```
##### LastMessage #####
Псоледнее сообщение в чате
```cpp
public DMessage LastMessage { get; set; }
```
##### UnreadMessagesNumber #####
Число не проитанных пользователем сообщений
```cpp
public int UnreadMessagesNumber { get; set; }
```
##### Relations #####
Связи
```cpp
public List<DChatRelation> Relations { get; set; }
```
<a name="NotifiableDChatInfo"/>
#####Список полей **NotifiableDChatInfo**#####
##### IsNotifiable #####
Признак подписки пользователя на уведомления по чату
```cpp
public bool IsNotifiable { get; set; }
```
##### DChatInfo #####
Чат
```cpp
public DChatInfo DChatInfo { get; set; }
```
<a name="DChatMember"/>
#####Список полей **DChatMember**#####
##### ChatId #####
Идентификатор чата
```cpp
public Guid ChatId { get; set; }
```
##### PersonId #####
Идентификатор участника
```cpp
public int PersonId { get; set; }
```
##### IsAdmin #####
Признак администратора
```cpp
public bool IsAdmin { get; set; }
```
##### IsDeleted #####
Удаленный участник
```cpp
public bool IsDeleted { get; set; }
```
##### IsNotifiable #####
Участник подписан на уведомления
```cpp
public bool IsNotifiable { get; set; }
```
##### DateUpdatedUtc #####
Дата изменения участника в UTC
```cpp
public DateTime DateUpdatedUtc { get; set; }
```
##### IsViewerOnly #####
Признак того, что участник просматривает чат по объекту, но не участвует в нем
```cpp
public bool IsViewerOnly { get; set; }
```
<a name="DChatRelation"/>
#####Список полей **DChatRelation**#####
##### ObjectId #####
Идентификатор объекта, с которым установлена связь
```cpp
public Guid ObjectId { get; set; }
```
##### Type #####
Тип связи
```cpp
public ChatRelationType Type { get; set; }
```
##### MessageId #####
Сообщение, создавшее связь
```cpp
public Guid? MessageId { get; set; }
```
##### IsDeleted #####
Признак удаленной связи
```cpp
public bool IsDeleted { get; set; }
```
<a name="DSearchDefinition"/>
#####Список полей **DSearchDefinition**#####
##### Id #####
Идентификатор поискового запроса
```cpp
public Guid Id { get; set; }
```
##### Request #####
Запрос поиска
```cpp
public DSearchRequest Request { get; }
```
<a name="DSearchRequest"/>
#####Список полей **DSearchRequest**#####
##### SearchString #####
“Условие поиска” в виде строки
```cpp
public string SearchString { get; set; }
```
##### SearchKind #####
Тип поиска
```cpp
public SearchKind SearchKind { get; set; }
```
Используйте `SearchKind.Custom` для формирования запросов поиска
##### MaxResults #####
Ограничение количества результатов поиска
```cpp
public int MaxResults { get; set; }
```
##### SortDefinitions #####
Позволяет установить поля и направления сортировки результатов поиска
```cpp
public List<DSortDefinition> SortDefinitions { get; }
```