/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Windows.Annotations;

namespace Pilot.Xps.Domain.Annotations
{
    class AnnotationsHelper
    {
        public const string XMLNS = AnnotationConstants.ANNOT_NAMESPACE;
        public static DateTime GetModifyDateFromAnnotation(Annotation annotation)
        {
            var metaresource = annotation.Cargos.Single(c => c.Name.Equals("Meta Data"));
            var metaElement = metaresource.Contents.Single(c => c.Name.Equals("anb:MetaData") && c.NamespaceURI.Equals(XMLNS));
            var date = metaElement.GetAttribute("LastModified", XMLNS);
            return DateTime.TryParse(date, CultureInfo.InvariantCulture, DateTimeStyles.None, out var dateTime) ? dateTime : annotation.CreationTime;
        }

        private static readonly FieldInfo ModifiedField = typeof(Annotation).GetField("_modified", BindingFlags.NonPublic | BindingFlags.Instance);

        public static void ChangeMicrosoftModificationTime(Annotation annotation)
        {
            ModifiedField?.SetValue(annotation, GetModifyDateFromAnnotation(annotation));
        }
    }
}
