/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Buffers.Text;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.IO.Packaging;
using System.Linq;
using System.Threading;
using System.Windows.Xps.Packaging;
using System.Xml.Linq;
using Ascon.Pilot.Common;
using Ascon.Pilot.DataClasses;
using Ascon.Pilot.DataModifier;
using Pilot.Xps.Domain.IO;
using Pilot.Xps.Domain.Labels;
using Pilot.Xps.Domain.Render;

namespace Pilot.Xps.Domain.GraphicLayer
{
    //class GraphicLayersInjector
    //{
    //    private readonly IBarcodeLabelsMerger _barcodeLabelsMerger;
    //    private readonly IXpsDocumentObject _xpsDocumentObject;

    //    public GraphicLayersInjector(IXpsDocumentObject xpsDocumentObject, IContextThreadDispatcher dispatcher, IBarcodeLabelsMerger barcodeLabelsMerger,
    //        IModifierBase modifier)
    //    {
    //        _xpsDocumentObject = xpsDocumentObject;
    //        _dispatcher = dispatcher;
    //        _barcodeLabelsMerger = barcodeLabelsMerger;
    //        _modifier = modifier;
    //    }

    //    public Stream InjectNew(IContext context, Stream documentStream, IList<GraphicLayerElement> graphicLayers, BarcodeLabelContent labelsContent, out List<INFile> injectedFiles)
    //    {
    //        var values = _xpsDocumentObject.DObject.Attributes;
    //        var documentLink = Base64.EncodeDocumentLink(_xpsDocumentObject.Id, DateTime.Now.Ticks);
    //        if (labelsContent == null)
    //        {
    //            var labelsFactory = new PilotBarcodeLabelsFactory(_xpsDocumentObject, context, _dispatcher, context.GetRepository().AsBackend());
    //            labelsContent = GetBarcodeLabelsContent(labelsFactory.GetImporter());
    //        }
    //        var barcodeFactory = new PilotCreateBarcodeLabelsFactory(_xpsDocumentObject.Type, values, documentLink, labelsContent, _dispatcher);
    //        var barcodeContent = GetBarcodeLabelsContent(barcodeFactory.GetImporter());

    //        return Inject(labelsContent, barcodeContent, documentStream, graphicLayers, out injectedFiles);
    //    }

    //    public Stream InjectChanged(IBarcodeLabelsFactory labelsFactory, IBarcodeLabelsFactory barcodeFactory, Stream documentStream,
    //        IList<GraphicLayerElement> graphicLayers, out List<INFile> injectedFiles)
    //    {
    //        var labelsContent = GetBarcodeLabelsContent(labelsFactory.GetImporter());
    //        var barcodeContent = GetBarcodeLabelsContent(barcodeFactory.GetImporter());
    //        return Inject(labelsContent, barcodeContent, documentStream, graphicLayers, out injectedFiles);
    //    }

    //    private Stream Inject(BarcodeLabelContent labelsContent, BarcodeLabelContent barcodeContent, Stream documentStream, IList<GraphicLayerElement> graphicLayers, out List<INFile> injectedFiles)
    //    {
    //        var resultStream = documentStream;
    //        injectedFiles = new List<INFile>();
    //        var barcodeLabelsFile = _xpsDocumentObject.Files.FirstOrDefault(x => FileExtensionHelper.IsInjectingFile(x.Name));

    //        var xpsFile = _xpsDocumentObject.Files.FirstOrDefault(x => FileExtensionHelper.IsXpsAlike(x.Name));

    //        if (xpsFile == null)
    //            return resultStream;

    //        if (barcodeLabelsFile != null && !xpsFile.InjectedFiles.Contains(barcodeLabelsFile.Id))
    //        {
    //            if (labelsContent.HasContentForInject)
    //            {
    //                resultStream = InjectBarcodeLabel(resultStream, _barcodeLabelsMerger, labelsContent, barcodeContent);
    //                if (labelsContent.HasContentForInject)
    //                {
    //                    injectedFiles.Add(barcodeLabelsFile);

    //                    var filteredFiles = _xpsDocumentObject.Files.Where(file => file.Id != barcodeLabelsFile.Id).ToList();
    //                    _xpsDocumentObject.Files = new ReadOnlyCollection<INFile>(filteredFiles);
    //                }
    //            }
    //        }

    //        if (graphicLayers.Any(l => !l.IsFloating))
    //        {
    //            var embedLayers = graphicLayers.Where(l => !l.IsFloating).ToList();
    //            var xpsWriter = new XpsWriter(_dispatcher);
    //            resultStream = xpsWriter.InjectGraphicLayerElements(resultStream ?? documentStream, embedLayers);
    //            var filteredFiles = _xpsDocumentObject.Files.Where(file => !embedLayers.Any(l => file.Name.Contains(l.ElementId.ToString())
    //                                                                                        || file.Name.Contains(l.ContentId.ToString()))).ToList();

    //            injectedFiles.AddRange(_xpsDocumentObject.Files.Where(file => !filteredFiles.Contains(file)));

    //            _xpsDocumentObject.Files = new ReadOnlyCollection<INFile>(filteredFiles);
    //        }

    //        return resultStream;
    //    }

    //    private BarcodeLabelContent GetBarcodeLabelsContent(IBarcodeLabelImporter barcodeImporter)
    //    {
    //        var barcodeEventArgs = barcodeImporter.Load();

    //        if (barcodeEventArgs.Exception != null)
    //            throw barcodeEventArgs.Exception;

    //        var barcodeLabelsContent = new BarcodeLabelContent(barcodeEventArgs.TextLabels, barcodeEventArgs.Barcode, barcodeEventArgs.Values, barcodeEventArgs.AttributeNames);
    //        return barcodeLabelsContent;
    //    }

    //    private Stream InjectBarcodeLabel(Stream stream, IBarcodeLabelsMerger merger, BarcodeLabelContent labelContent, BarcodeLabelContent barcodeContent)
    //    {
    //        Stream res = null;
    //        Exception ex = null;

    //        var thread = new Thread(() =>
    //        {
    //            try
    //            {
    //                var textlabels = labelContent.TextLabelsDescription;
    //                var barcode = barcodeContent.BarcodeDescription;
    //                res = merger.Merge(stream, XpsWriter.GetConstantTextLabel(BarcodeLabelsDrawer.TextLabelListToString(textlabels)), XpsWriter.GetConstantBarcode(barcode),
    //                    labelContent.Values, labelContent.AttributeNames);
    //            }
    //            catch (Exception e)
    //            {
    //                ex = e;
    //                res = null;
    //            }
    //        });
    //        thread.SetApartmentState(ApartmentState.STA);
    //        thread.Start();
    //        thread.Join();

    //        if (ex != null)
    //            throw ex;

    //        if (res == null)
    //            throw new Exception("Cannot merge barcode and text labels");

    //        return res;
    //    }
    //}
    //    class GraphicLayerInjector
    //    {
    //        public Stream InjectGraphicLayerElements(Stream sourceStream, List<GraphicLayerElement> graphicLayerElments)
    //        {
    //            if (graphicLayerElments == null || graphicLayerElments.Count == 0)
    //                return sourceStream;

    //            var destStream = IoUtils.CreateMemoryStream(sourceStream);

    //            using (var sourcePackage = Package.Open(sourceStream, FileMode.Open, FileAccess.Read))
    //            {
    //                using (var resultPackage = Package.Open(destStream, FileMode.OpenOrCreate, FileAccess.ReadWrite))
    //                {
    //                    var listoflists = new List<List<GraphicLayerElement>>();
    //                    foreach (var graphicLayerElement in graphicLayerElments.Where(l => l.ContentType == XpsConstants.XAML || l.ContentType == XpsConstants.BITMAP))
    //                    {
    //                        var t = listoflists.FirstOrDefault(list => list.Any(element => element.PageNumber == graphicLayerElement.PageNumber));
    //                        if (t != null)
    //                            t.Add(graphicLayerElement);
    //                        else
    //                        {
    //                            listoflists.Add(new List<GraphicLayerElement> { graphicLayerElement });
    //                        }
    //                    }
    //                    foreach (var graphicLayerElement in listoflists)
    //                    {
    //                        if (graphicLayerElement.Count == 0)
    //                            continue;
    //                        var sourcePagePart = GetSourcePagePart(sourcePackage, graphicLayerElement[0].PageNumber);
    //                        if (sourcePagePart == null)
    //                            return destStream;

    //                        var imagesFiles = new List<ImageInfo>(graphicLayerElement.Count);

    //                        using (var stream = sourcePagePart.GetStream())
    //                        {
    //                            var fixedPage = XElement.Load(stream);
    //                            var defaultNamespace = fixedPage.GetDefaultNamespace();

    //                            var glNode = fixedPage.Nodes().FirstOrDefault(n =>
    //                            {
    //                                var tmp = n as XElement;
    //                                return tmp != null &&
    //                                       tmp.Attributes("Name").Any(atr => atr.Value.Equals("graphicLayerElements"));
    //                            }) as XElement;
    //                            if (glNode == null)
    //                            {
    //                                var pathWithImages = CreatePathesWithImages(graphicLayerElement, imagesFiles, (double)fixedPage.Attribute("Height"), (double)fixedPage.Attribute("Width"));
    //                                fixedPage.Add(XpsTools.TryParseXml(pathWithImages));
    //                            }
    //                            else
    //                            {
    //                                var pathWithImages = GetListOfLayersForXps(graphicLayerElement, imagesFiles, (double)fixedPage.Attribute("Height"), (double)fixedPage.Attribute("Width"));
    //                                foreach (var pathWithImage in pathWithImages)
    //                                {
    //                                    glNode.Add(XpsTools.TryParseXml(pathWithImage));
    //                                }
    //                            }

    //                            foreach (var ce in fixedPage.DescendantsAndSelf())
    //                                ce.Name = defaultNamespace + ce.Name.LocalName;

    //                            var resultPagePart = resultPackage.GetPart(sourcePagePart.Uri);
    //                            using (var resultPagePartStream = resultPagePart.GetStream(FileMode.Create))
    //                            {
    //                                fixedPage.Save(resultPagePartStream);
    //                            }

    //                            foreach (var imagesFile in imagesFiles)
    //                            {

    //                                var imageSource = "/Resources/" + Path.GetFileName(imagesFile.Uri);
    //                                resultPagePart.CreateRelationship(new Uri(imageSource,
    //                                    UriKind.Relative), TargetMode.Internal, XpsConstants.REQUIRED_RESOURCE);
    //                            }
    //                        }

    //                        foreach (var imageInfo in imagesFiles)
    //                        {
    //                            var file = "/Resources/" + Path.GetFileName(imageInfo.Uri);

    //                            string contentType;
    //                            switch (imageInfo.XpsImageType)
    //                            {
    //                                case XpsImageType.PngImageType:
    //                                    contentType = "image/png";
    //                                    break;
    //                                case XpsImageType.JpegImageType:
    //                                    contentType = "image/jpeg";
    //                                    break;
    //                                default:
    //                                    throw new BadImageFormatException("Unknown image type");
    //                            }

    //                            using (var imageStream = XpsTools.GetStreamInPackageAllowingMultipleFiles(resultPackage, XpsConstants.REQUIRED_RESOURCE, file, contentType))
    //                            {
    //                                using (var stream = File.Open(imageInfo.Uri, FileMode.Open))
    //                                {
    //                                    stream.CopyTo(imageStream);
    //                                }
    //                                File.Delete(imageInfo.Uri);
    //                            }
    //                        }
    //                    }
    //                }
    //            }

    //            destStream.Position = 0;
    //            return destStream;
    //        }
    //    }
    //}
}
