/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Markup;
using System.Windows.Media;
using System.Xml;
using System.Xml.Linq;
using Pilot.Xps.Domain.Render;

namespace Pilot.Xps.Domain.Labels
{
    class BarcodeLabelsDrawer// : IBarcodeLabelsDrawer
    {
        //private IBarcodeLabelsModifier _barcodeLabelsModifier;
        //private readonly IDocumentLayer _documentLayer;
        //private readonly IPreviewModel _previewModel;
        //private bool _canUserEdit;
        //private double _pageWidth;
        //private double _pageHeight;

        //internal readonly List<LabelAdorner> _labelsAdorners;
        //internal readonly List<BarcodeAdorner> _barcodeAdorners;
        //private string _barcodeTextDescription;

        //public BarcodeLabelsDrawer(IDocumentLayer documentLayer, IBarcodeLabelsModifier barcodeLabelsModifier, IPreviewModel previewModel, bool canUserEdit)
        //{
        //    _documentLayer = documentLayer;
        //    _canUserEdit = canUserEdit;
        //    _barcodeLabelsModifier = barcodeLabelsModifier;
        //    _previewModel = previewModel;
        //    _labelsAdorners = new List<LabelAdorner>();
        //    _barcodeAdorners = new List<BarcodeAdorner>();
        //}

        //public void RemoveLabelAdorners()
        //{
        //    foreach (var textBlockAdorner in _labelsAdorners)
        //    {
        //        _documentLayer.RemoveAdornerFromLayer(textBlockAdorner, AdornerLayerType.Document);
        //        textBlockAdorner.PositionChanged -= LabelAdornerOnPositionChanged;
        //    }
        //    _labelsAdorners.Clear();
        //}

        //private void RemoveLabelAdorners(int pageNumber)
        //{
        //    var adornersToRemove = _labelsAdorners.Where(textBlockAdorner => textBlockAdorner.PageNumber == pageNumber).ToList();
        //    foreach (var adorner in adornersToRemove)
        //    {
        //        _documentLayer.RemoveAdornerFromLayer(adorner, AdornerLayerType.Document);
        //        _labelsAdorners.Remove(adorner);
        //        adorner.PositionChanged -= LabelAdornerOnPositionChanged;
        //    }
        //}

        //public void RemoveBarcodeAdorner()
        //{
        //    foreach (var barcodeAdorner in _barcodeAdorners)
        //    {
        //        _documentLayer.RemoveAdornerFromLayer(barcodeAdorner, AdornerLayerType.Document);
        //        barcodeAdorner.PositionChanged -= BarcodeOnPositionChanged;
        //    }
        //    _barcodeAdorners.Clear();
        //}

        //private void RemoveBarcodeAdorners(int pageNumber)
        //{
        //    var adornersToRemove = _barcodeAdorners.Where(b => b.PageNumber == pageNumber).ToList();
        //    foreach (var adorner in adornersToRemove)
        //    {
        //        _documentLayer.RemoveAdornerFromLayer(adorner, AdornerLayerType.Document);
        //        adorner.PositionChanged -= BarcodeOnPositionChanged;
        //        _barcodeAdorners.Remove(adorner);
        //    }
        //}

        //public TextLabelList DrawLabelsFromDescription(TextLabelList textLabelsDescription, Dictionary<string, object> values, List<string> attributeNames)
        //{
        //    if (!textLabelsDescription.Any())
        //        return textLabelsDescription;

        //    _previewModel.BarcodeLabelsContent.TextLabelsDescription = textLabelsDescription;

        //    foreach (var page in _documentLayer.GetVisiblePages())
        //    {
        //        _pageHeight = _documentLayer.GetPageHeight(page.PageNumber);
        //        _pageWidth = _documentLayer.GetPageWidth(page.PageNumber);
        //        RemoveLabelAdorners(page.PageNumber);
        //        var pageView = _documentLayer.GetPageView(page.PageNumber);

        //        foreach (var label in _previewModel.BarcodeLabelsContent.TextLabelsDescription)
        //        {
        //            if (!IsInPageRange(label.PageRange, page.PageNumber, _documentLayer.PageCount))
        //                continue;

        //            if (pageView == null)
        //                continue;
        //            var labelAdorner = new LabelAdorner(pageView, label, _previewModel, values, attributeNames, _canUserEdit);
        //            labelAdorner.PositionChanged += LabelAdornerOnPositionChanged;
        //            _labelsAdorners.Add(labelAdorner);
        //            _documentLayer.AddAdornerToLayer(AdornerLayerType.Document, labelAdorner);
        //        }
        //    }

        //    return textLabelsDescription;
        //}

        public static TextBlock DrawTextBlock(TextLabel textLabel)
        {
            var xElementCopy = XElement.Parse(TextLabel.GetWrappedSquareBrackets(textLabel.TextLabelXElement.ToString()));

            TextLabel.RemoveAttribute(xElementCopy, BarcodeLabelsConstants.FLOATING_ATTRIBUTE);
            TextLabel.RemoveAttribute(xElementCopy, BarcodeLabelsConstants.HIDE_IF_EMPTY_VALUE_ATTRIBUTE);
            TextLabel.RemoveAttribute(xElementCopy, BarcodeLabelsConstants.TEXT_LABEL_PAGE_RANGE);
            TextLabel.RemoveAttribute(xElementCopy, BarcodeLabelsConstants.ANGLE_ATTRIBUTE);
            TextLabel.RemoveAttribute(xElementCopy, BarcodeLabelsConstants.KEEP_WITHIN_PAGE_BOUNDS_ATTRIBUTE);

            var nsmgr = new XmlNamespaceManager(new NameTable());
            nsmgr.AddNamespace(string.Empty, @"http://schemas.microsoft.com/winfx/2006/xaml/presentation");

            XmlReaderSettings settings = new XmlReaderSettings();
            settings.IgnoreWhitespace = false;

            var xmlParserContext = new XmlParserContext(null, nsmgr, null, XmlSpace.None);
            var xmlReader = XmlReader.Create(new StringReader(xElementCopy.ToString()), settings, xmlParserContext);


            var obj = XamlReader.Load(xmlReader);
            var tb = (TextBlock)obj;

            SetNewText(tb, textLabel.Value, TextLabel.GetUnwrappedSquareBrackets);

            if (!double.TryParse(textLabel.LeftValue, out var left))
                textLabel.Left = Canvas.GetLeft(tb);

            if (!double.TryParse(textLabel.RightValue, out var right))
                textLabel.Right = Canvas.GetRight(tb);

            if (!double.TryParse(textLabel.TopValue, out var top))
                textLabel.Top = Canvas.GetTop(tb);

            if (!double.TryParse(textLabel.BottomValue, out var bottom))
                textLabel.Bottom = Canvas.GetBottom(tb);

            return tb;
        }

        //public static List<TextBlock> DrawTextBlocks(TextLabelList textLabelList)
        //{
        //    var list = new List<TextBlock>();
        //    foreach (var textLabel in textLabelList)
        //    {
        //        list.Add(DrawTextBlock(textLabel));
        //    }

        //    return list;
        //}

        public static TextLabel GeTextLabelFromTextBlock(TextBlock textBlock) => new TextLabel(string.Empty)
        {
            TextWrapping = textBlock.TextWrapping,
            FontSize = textBlock.FontSize,
            FontFamily = textBlock.FontFamily,
            HorizontalAlignment = textBlock.HorizontalAlignment,
            VerticalAlignment = textBlock.VerticalAlignment,
            Width = textBlock.Width,
            Height = textBlock.Height,
            Text = textBlock.Text
        };

        //public static string TextLabelListToString(TextLabelList textLabelList)
        //{
        //    var sb = new StringBuilder("<TextBlocks>");
        //    foreach (var textLabel in textLabelList)
        //    {
        //        sb.Append(TextLabelToString(textLabel));
        //    }
        //    sb.Append("</TextBlocks>");
        //    return sb.ToString();
        //}

        //public static string TextLabelToString(TextLabel textLabel)
        //{
        //    var options = RegexOptions.Compiled | RegexOptions.Singleline;
        //    var pattern = "(?<start><TextBlock(.*?)>)(?<value>(.*))(?<end></TextBlock>)";

        //    var str = textLabel.TextLabelXElement.ToString();
        //    var replacePattern = "${start}" + textLabel.Value + "${end}";
        //    return Regex.Replace(str, pattern, replacePattern, options);
        //}

        private static void SetNewText(TextBlock textBlock, string value, Func<string, string> wrapFunc)
        {
            var inlinesCopy = textBlock.Inlines.ToArray();
            var values = Regex.Split(value, "<LineBreak(.*?)/>");
            textBlock.Text = values[0];
            textBlock.Inlines.Clear();
            var i = 0;
            foreach (var inline in inlinesCopy)
            {
                if (inline is Run run)
                    textBlock.Inlines.Add(wrapFunc(values[i]));
                if (inline is LineBreak)
                    textBlock.Inlines.Add(new LineBreak());

                i++;
            }
        }

        public static Size MeasureTextblock(TextBlock textBlock, string text)
        {
            var dpiScale = VisualTreeHelper.GetDpi(textBlock);
            var formattedText = new FormattedText(
                text,
                CultureInfo.CurrentUICulture,
                FlowDirection.LeftToRight,
                new Typeface(textBlock.FontFamily, textBlock.FontStyle, textBlock.FontWeight, textBlock.FontStretch),
                    textBlock.FontSize,
                    Brushes.Black, dpiScale.PixelsPerDip);

            return new Size(formattedText.Width, formattedText.Height);
        }

        //public string DrawBarcodeFromDescription(string barcode)
        //{
        //    _barcodeTextDescription = barcode;
        //    if (string.IsNullOrEmpty(barcode))
        //        return barcode;

        //    foreach (var page in _documentLayer.GetVisiblePages())
        //    {
        //        RemoveBarcodeAdorners(page.PageNumber);

        //        _pageHeight = _documentLayer.GetPageHeight(page.PageNumber);
        //        _pageWidth = _documentLayer.GetPageWidth(page.PageNumber);
        //        var barcodeComponents = XpsTools.GetBarcode(barcode);

        //        if (!IsInPageRange(barcodeComponents.PageRange, page.PageNumber, _documentLayer.PageCount))
        //            continue;

        //        var correctedPoint = CheckBarcodeSizeAndPosition(barcodeComponents);
        //        correctedPoint = CorrectNegativePoint(correctedPoint.X, correctedPoint.Y);

        //        barcode = XpsTools.SetOffsetsToBarcode(barcode, correctedPoint.X, correctedPoint.Y);
        //        barcode = XpsTools.DeleteAlignments(barcode);

        //        var barcodeAdorner = new BarcodeAdorner(page, barcode, _previewModel, _canUserEdit);
        //        barcodeAdorner.PositionChanged += BarcodeOnPositionChanged;
        //        _documentLayer.AddAdornerToLayer(AdornerLayerType.Document, barcodeAdorner);
        //        _barcodeAdorners.Add(barcodeAdorner);
        //    }

        //    return barcode;
        //}

        //private bool IsInPageRange(string pageRange, int pageNumber, int maxPage)
        //{
        //    var parsedRange = PagesPrintOrder.Parse(pageRange, maxPage, 1);
        //    return parsedRange.Contains(pageNumber + 1);
        //}

        public static Point CorrectNegativePoint(double correctedPointX, double correctedPointY)
        {
            if (correctedPointX < 0)
                correctedPointX = 0;
            if (correctedPointY < 0)
                correctedPointY = 0;
            return new Point(correctedPointX, correctedPointY);
        }

        //private FrameworkElement GetActivElement(BarcodeDescription barcode)
        //{
        //    if (barcode.Barcode != null)
        //        return barcode.Barcode;
        //    return barcode.TextBlock;
        //}

        //private Point CheckBarcodeSizeAndPosition(BarcodeDescription barcode)
        //{
        //    double x;
        //    double y;
        //    if (GetActivElement(barcode) != null)
        //    {
        //        x = Canvas.GetLeft(GetActivElement(barcode));
        //        y = Canvas.GetTop(GetActivElement(barcode));
        //    }
        //    else
        //    {
        //        return new Point();
        //    }
        //    if (double.IsNaN(x))
        //        x = 0;
        //    if (double.IsNaN(y))
        //        y = 0;
        //    Size size;
        //    if (barcode.Barcode != null)
        //        size = new Size(barcode.Barcode.Data.Bounds.Width, barcode.Barcode.Data.Bounds.Height);
        //    else
        //        size = new Size(MeasureTextblock(barcode.TextBlock, barcode.TextBlock.Text).Width, 0);
        //    if (barcode.TextBlock != null)
        //        size.Height += MeasureTextblock(barcode.TextBlock, barcode.TextBlock.Text).Height;
        //    switch (barcode.HorizontalAlignment)
        //    {
        //        case HorizontalAlignment.Right:
        //            x = _pageWidth + x - size.Width;
        //            break;
        //        case HorizontalAlignment.Center:
        //            x = ((_pageWidth - size.Width) / 2) + x;
        //            break;
        //    }

        //    switch (barcode.VerticalAlignment)
        //    {
        //        case VerticalAlignment.Bottom:
        //            y = _pageHeight + y - size.Height;
        //            break;
        //        case VerticalAlignment.Center:
        //            y = ((_pageHeight - size.Height) / 2) + y;
        //            break;
        //    }
        //    var leftTop = new Point(x, y);
        //    var leftBottom = new Point(x, y + size.Height);
        //    var rightTop = new Point(x + GetCorrectWidth(barcode, size), y);
        //    var rightBottom = new Point(x + GetCorrectWidth(barcode, size), y + size.Height);
        //    var matrix = Matrix.Identity;
        //    matrix.RotateAtPrepend(barcode.Angle, x, y);
        //    matrix.ScaleAt(barcode.Scale, barcode.Scale, x, y);
        //    var newLeftBottom = matrix.Transform(leftBottom);
        //    var newRightTop = matrix.Transform(rightTop);
        //    var newRightBottom = matrix.Transform(rightBottom);
        //    x = PositioningHelper.CheckFarestCoordinate(leftTop.X, newRightTop.X, newRightBottom.X, newLeftBottom.X, _pageWidth);
        //    y = PositioningHelper.CheckFarestCoordinate(leftTop.Y, newRightTop.Y, newRightBottom.Y, newLeftBottom.Y, _pageHeight);
        //    return new Point(x, y);
        //}

        //private double GetCorrectWidth(BarcodeDescription barcode, Size size)
        //{
        //    if (barcode.Barcode == null)
        //        return size.Width;
        //    return barcode.Barcode.Data.Bounds.Width;
        //}

        //public void SetModifier(IBarcodeLabelsModifier barcodeLabelsModifier)
        //{
        //    _barcodeLabelsModifier = barcodeLabelsModifier;
        //}

        //private void LabelAdornerOnPositionChanged(object sender, TextLabelEventArgs eventArgs)
        //{
        //    if (_barcodeLabelsModifier != null)
        //    {
        //        var a = (LabelAdorner)sender;

        //        a.TextLabel.Left = eventArgs.CanvasLeft;
        //        a.TextLabel.Top = eventArgs.CanvasTop;
        //        a.TextLabel.Right = eventArgs.CanvasRight;
        //        a.TextLabel.Bottom = eventArgs.CanvasBottom;

        //        _barcodeLabelsModifier.MoveBarcodeLabel(_previewModel.BarcodeLabelsContent.TextLabelsDescription, null);

        //        if (!_previewModel.IsReadOnly)
        //        {
        //            _previewModel.OnSavingChanges();
        //            _barcodeLabelsModifier.SaveLabels(_previewModel.BarcodeLabelsContent.TextLabelsDescription);
        //        }
        //    }
        //}

        //private void BarcodeOnPositionChanged(object sender, BarcodeControl.PositionCompletedEventArgs eventArgs)
        //{
        //    if (_barcodeLabelsModifier != null && !string.IsNullOrEmpty(_barcodeTextDescription))
        //    {
        //        _barcodeTextDescription = XpsTools.DeleteAlignments(_barcodeTextDescription);
        //        _barcodeTextDescription =
        //            XpsTools.SetOffsetsToBarcode(_barcodeTextDescription, eventArgs.X, eventArgs.Y);
        //        _previewModel.BarcodeLabelsContent.BarcodeDescription = _barcodeTextDescription;
        //        _barcodeLabelsModifier.MoveBarcodeLabel(null, _barcodeTextDescription);
        //        if (!_previewModel.IsReadOnly)
        //        {
        //            _previewModel.OnSavingChanges();
        //            _barcodeLabelsModifier.SaveBarcode(_barcodeTextDescription);
        //        }
        //    }
        //}

        //public void OnClosed()
        //{
        //}
    }
}
