/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Windows;

namespace Pilot.Xps.Domain.Render
{
    interface IXpsWriter
    {
        List<Tuple<string, Uri, Stream, int>> GenerateGlyphsFromTextLabels(string textLabelsConfiguration, List<Size> pageSizes, Dictionary<string, object> attributesValues, List<string> attributeNames);
        Stream AddTextLabelsAndBarcode(Stream sourceStream, List<Tuple<string, Uri, Stream, int>> textLabels, Tuple<Tuple<string, Uri, Stream, int>, HorizontalAlignment, VerticalAlignment, double> barcode = null);
        Size GetFirstPageSizeFromXps(Stream docStream);
        List<Size> GetPagesSizes(Stream docStream);
        Stream InjectGraphicLayerElements(Stream sourceStream, List<GraphicLayerElement> graphicLayerElments);
    }
}
