/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.IO.Packaging;
using System.Linq;
using System.Windows.Xps.Packaging;
using Pilot.Xps.Domain.Tools;
using Pilot.Xps.Domain.Windows;

namespace Pilot.Xps.Domain
{
    static class PackageExt
    {
        public static List<PackagePart> GetPages(this Package package)
        {
            return package.GetParts()
                .Where(sourcePart => sourcePart.ContentType == XpsConstants.FIXED_PAGE_CONTENT_TYPE)
                .OrderBy(x => x.Uri.ToString(), new NaturalComparer()).ToList();
        }

        public static void WithRegistered(this Package package, Action<XpsDocument> action)
        {
            WithRegistered(package, CompressionOption.Normal, action);
        }

        public static void WithRegisteredNotCompressed(this Package package, Action<XpsDocument> action)
        {
            WithRegistered(package, CompressionOption.NotCompressed, action);
        }

        public static void WithRegistered(this Package package, CompressionOption co, Action<XpsDocument> action)
        {
            var uri = GetRandomPackageUri();
            using (new PackageReference(package, uri))
            using (var document = new XpsDocument(package, co, uri.AbsoluteUri))
            {
                action(document);
            }
        }

        public static T WithRegistered<T>(this Package package, CompressionOption co, Func<XpsDocument, T> action)
        {
            var uri = GetRandomPackageUri();
            using (new PackageReference(package, uri))
            using (var document = new XpsDocument(package, co, uri.AbsoluteUri))
            {
                return action(document);
            }
        }

        private static Uri GetRandomPackageUri()
        {
            return new Uri("memorystream://" + Guid.NewGuid());
        }
    }
}
