/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using System.Linq;
using Pilot.Xps.Connection.Client;
using Pilot.Xps.Entities;

namespace Pilot.Xps.Client
{
    class Program
    {
        static void Main(string[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("Params not set");
                return;
            }

            var settings = new AppSettings();
            var client = new ClientApi();

            Console.WriteLine($"Connecting to server {settings.ConnectionParams.Server}");
            client.Connect(settings);

            Console.WriteLine("Connected");

            var api = client.GetRemoteApi();
            if (args.Contains("-m"))
            {
                RunMergeCommand(args, api);
            }

            if (args.Contains("-s"))
            {
                RunSignCommand(args, api);
            }

            Console.WriteLine("Done");
        }

        private static void RunMergeCommand(string[] args, IRepository repository)
        {
            var documentId = Guid.Parse(args[1]);
            var pathToSave = args[2];
            if (File.Exists(pathToSave))
                File.Delete(pathToSave);

            var xpsApi = repository.GetServerCommandProxy<IXpsServiceApi>(XpsServerConstants.XpsServiceName);
            var bytes = xpsApi.MergeXpsDocument(documentId);
            File.WriteAllBytes(pathToSave, bytes);
        }

        private static void RunSignCommand(string[] args, IRepository repository)
        {
            var documentId = Guid.Parse(args[1]);
            var personId = int.Parse(args[2]);

            var xpsApi = repository.GetServerCommandProxy<IXpsServiceApi>(XpsServerConstants.XpsServiceName);
            xpsApi.SignDocument(documentId, personId);
        }
    }
}
