/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using Ascon.Pilot.Server.Api;

namespace Pilot.Xps.Connection.Client
{
    public class ClientApi : IConnectionLostListener
    {
        private HttpPilotClient _client;
        private Repository _repository;

        public void Connect(IConnectionSettings connectionSettings)
        {
            if (connectionSettings == null) throw new ArgumentNullException(nameof(connectionSettings));
            _client?.Dispose();

            var credentials = ConnectionCredentials.GetConnectionCredentials(connectionSettings.ConnectionParams);
            _client = new HttpPilotClient(credentials.GetConnectionString(), credentials.GetConnectionProxy());
            _client.SetConnectionLostListener(this);
            _client.Connect(false);

            _client.GetAuthenticationApi().Login(credentials.DatabaseName,
                credentials.Username,
                credentials.ProtectedPassword,
                false,
                connectionSettings.LicenseCode);
            
            var callback = new ServerCallback();
            var serverApi = _client.GetServerApi(callback);
            _repository = new Repository(serverApi);
            callback.SetCallback(_repository);
            
            serverApi.OpenDatabase();
        }

        public IRepository GetRemoteApi()
        {
            return _repository;
        }

        public void ConnectionLost(Exception ex = null)
        {
            
        }
    }
}
