/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.IO;
using Ascon.Pilot.Common;
using Ascon.Pilot.Common.DataProtection;
using Newtonsoft.Json;

namespace Pilot.Xps.Service
{
    static class AppSettingsProvider
    {
        public static AppSettings LoadAppSettings()
        {
            AppSettingsJson json;
            using (var reader = new StreamReader(AppDomain.CurrentDomain.BaseDirectory + "/appsettings.json"))
            {
                json = JsonConvert.DeserializeObject<AppSettingsJson>(reader.ReadToEnd());
            }

            var settings = new AppSettings(json);
            return settings;
        }

        public static void SaveAppSettings(AppSettings settings)
        {
            using (var writer = new StreamWriter(AppDomain.CurrentDomain.BaseDirectory + "/appsettings.json"))
            {
                var json = settings.ToAppSettingsJson();
                var jsonString = JsonConvert.SerializeObject(json, Formatting.Indented);
                writer.Write(jsonString);
            }
        }

        public static AppSettingsJson ToAppSettingsJson(this AppSettings settings)
        {
            var json = new AppSettingsJson
            {
                Connection = new ConnectionJson
                {
                    LicenseCode = settings.ConnectionSettings.LicenseCode,
                    Password = settings.ConnectionSettings.ConnectionParams.Password.ConvertToUnsecureString().EncryptAes(),
                    Server = settings.ConnectionSettings.ConnectionParams.Server,
                    UserName = settings.ConnectionSettings.ConnectionParams.UserName
                },
                Signing = new SigningSettingsJson
                {
                    CertificatesMap = settings.SigningSettings.CertificatesMap,
                    StoreLocation = settings.SigningSettings.StoreLocation
                }
            };
            return json;
        }
    }
}
