/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using PilotRocketChatGateway.UserContext;
using System.Security.Cryptography;
using System;
using Newtonsoft.Json.Converters;
using System.Dynamic;
using PilotRocketChatGateway.Authentication;
using Ascon.Pilot.DataClasses;
using PilotRocketChatGateway.PilotServer;

namespace PilotRocketChatGateway.Controllers
{
    [ApiController]
    public class MethodController : ControllerBase
    {
        private IContextsBank _contextsBank;
        private IAuthHelper _authHelper;

        public MethodController(IContextsBank contextsBank, IAuthHelper authHelper)
        {
            _contextsBank = contextsBank;
            _authHelper = authHelper;
        }

        [Authorize]
        [HttpPost("api/v1/method.call/spotlight")]
        public string Spotlight(object request)
        {
            var context = _contextsBank.GetContext(HttpContext.GetTokenActor(_authHelper));
            var str = request.ToString();
            dynamic dRequest = JsonConvert.DeserializeObject<ExpandoObject>(str, new ExpandoObjectConverter());
            dynamic data = JsonConvert.DeserializeObject<ExpandoObject>(dRequest.message, new ExpandoObjectConverter());

            if (data.@params != null && data.@params.Count > 2)
            {
                var text = (string)data.@params[0];
                var isUsers = (bool)data.@params[2].users;
                var isRoom = (bool)data.@params[2].rooms;

                if (isRoom)
                {
                    var (rooms, _) = context.ChatService.DataLoader.LoadChannels(int.MaxValue, 0, text.ToLower());
                    var result = new
                    {
                        message = JsonConvert.SerializeObject(new
                        {
                            error = false,
                            result = new
                            {
                                rooms = rooms
                            }
                        })
                    };
                    return JsonConvert.SerializeObject(result);
                }

                if (isUsers)
                {
                    var rid = (string)data.@params[3];
                    var (users, total) = context.ChatService.DataLoader.LoadMembers(rid, int.MaxValue, 0, text.ToLower());
                    var result = new
                    {
                        message = JsonConvert.SerializeObject(new
                        {
                            error = false,
                            result = new
                            {
                                users = users
                            }
                        })
                    };
                    return JsonConvert.SerializeObject(result);
                }

            }

            var result0 = new HttpResult() { success = true };
            return JsonConvert.SerializeObject(result0);
            
        }

        [Authorize]
        [HttpPost("api/v1/method.call/loadSurroundingMessages")]
        public string LoadSurroundingMessages(object request)
        {
            var context = _contextsBank.GetContext(HttpContext.GetTokenActor(_authHelper));


            dynamic dRequest = JsonConvert.DeserializeObject<ExpandoObject>(request.ToString(), new ExpandoObjectConverter());
            dynamic dRequest2 = JsonConvert.DeserializeObject<ExpandoObject>(dRequest.message, new ExpandoObjectConverter());

            string msgId = dRequest2.@params[0]._id;
            string rid = dRequest2.@params[0].rid;
            int count = unchecked((int)dRequest2.@params[1]);

            var msgs = context.ChatService.DataLoader.LoadSurroundingMessages(msgId, rid, count);
            var result = new
            {
                message = JsonConvert.SerializeObject(new
                {
                    error = false,
                    result = new
                    {
                        messages = msgs
                    }
                })
            };
            return JsonConvert.SerializeObject(result);
        }
    }
}
